/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.util;

import java.util.Date;
import org.apache.shindig.util.BlobCrypterException;

public class BlobExpiredException
extends BlobCrypterException {
    public final Date minDate;
    public final Date used;
    public final Date maxDate;

    public BlobExpiredException(long minTime, long now, long maxTime) {
        this(new Date(minTime * 1000L), new Date(now * 1000L), new Date(maxTime * 1000L));
    }

    public BlobExpiredException(Date minTime, Date now, Date maxTime) {
        super("Blob expired, was valid from " + minTime + " to " + maxTime + ", attempted use at " + now);
        this.minDate = minTime;
        this.used = now;
        this.maxDate = maxTime;
    }
}

