/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class InputStreamConsumer {
    public static byte[] readToByteArray(InputStream is) throws IOException {
        return InputStreamConsumer.readToByteArray(is, Integer.MAX_VALUE);
    }

    public static byte[] readToByteArray(InputStream is, int maxBytes) throws IOException {
        int chunkSize;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] chunk = new byte[8192];
        while (out.size() < maxBytes && (chunkSize = is.read(chunk)) != -1) {
            out.write(chunk, 0, chunkSize);
        }
        return out.toByteArray();
    }

    public static String readToString(InputStream is) throws IOException {
        return InputStreamConsumer.readToString(is, Integer.MAX_VALUE);
    }

    public static String readToString(InputStream is, int maxBytes) throws IOException {
        try {
            return new String(InputStreamConsumer.readToByteArray(is, maxBytes), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported!", e);
        }
    }

    public static void pipe(InputStream is, OutputStream os) throws IOException {
        os.write(InputStreamConsumer.readToByteArray(is));
    }
}

