/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.util;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.shindig.util.XmlException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static String getAttribute(Node node, String attr, String def) {
        NamedNodeMap attrs = node.getAttributes();
        Node val = attrs.getNamedItem(attr);
        if (val != null) {
            return val.getNodeValue();
        }
        return def;
    }

    public static String getAttribute(Node node, String attr) {
        return XmlUtil.getAttribute(node, attr, null);
    }

    public static URI getUriAttribute(Node node, String attr, URI def) {
        String uri = XmlUtil.getAttribute(node, attr);
        if (uri != null) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                return def;
            }
        }
        return def;
    }

    public static URI getUriAttribute(Node node, String attr) {
        return XmlUtil.getUriAttribute(node, attr, null);
    }

    public static boolean getBoolAttribute(Node node, String attr, boolean def) {
        String value = XmlUtil.getAttribute(node, attr);
        if (value == null) {
            return def;
        }
        return !"false".equals(value);
    }

    public static boolean getBoolAttribute(Node node, String attr) {
        return XmlUtil.getBoolAttribute(node, attr, false);
    }

    public static Element parse(String xml) throws XmlException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            InputSource is = new InputSource(new StringReader(xml.trim()));
            return factory.newDocumentBuilder().parse(is).getDocumentElement();
        }
        catch (SAXException e) {
            throw new XmlException(e);
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
    }
}

