/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.samples.aspectj.bank;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.shiro.samples.aspectj.bank.AccountTransaction;
import org.apache.shiro.samples.aspectj.bank.InactiveAccountException;
import org.apache.shiro.samples.aspectj.bank.NotEnoughFundsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Account {
    private static long _SEQUENCE;
    private long _id = ++_SEQUENCE;
    private String _ownerName;
    private volatile boolean _isActive;
    private double _balance;
    private final List<AccountTransaction> _transactions;
    private String _createdBy;
    private Date _creationDate;

    public Account(String anOwnerName) {
        this._ownerName = anOwnerName;
        this._isActive = true;
        this._balance = 0.0;
        this._transactions = new ArrayList<AccountTransaction>();
        this._createdBy = "unknown";
        this._creationDate = new Date();
    }

    public long getId() {
        return this._id;
    }

    public String getOwnerName() {
        return this._ownerName;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setActive(boolean aIsActive) {
        this._isActive = aIsActive;
    }

    public void setOwnerName(String aOwnerName) {
        this._ownerName = aOwnerName;
    }

    public double getBalance() {
        return this._balance;
    }

    public List<AccountTransaction> getTransactions() {
        return this._transactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyTransaction(AccountTransaction aTransaction) throws NotEnoughFundsException, InactiveAccountException {
        if (!this._isActive) {
            throw new InactiveAccountException("Unable to apply " + (Object)((Object)aTransaction.getType()) + " of amount " + aTransaction.getAmount() + " to account " + this._id);
        }
        List<AccountTransaction> list = this._transactions;
        synchronized (list) {
            if (AccountTransaction.TransactionType.DEPOSIT == aTransaction.getType()) {
                this._transactions.add(aTransaction);
                this._balance += aTransaction.getAmount();
            } else if (AccountTransaction.TransactionType.WITHDRAWAL == aTransaction.getType()) {
                if (this._balance < aTransaction.getAmount()) {
                    throw new NotEnoughFundsException("Unable to withdraw " + aTransaction.getAmount() + "$ from account " + this._id + " - current balance is " + this._balance);
                }
                this._transactions.add(aTransaction);
                this._balance -= aTransaction.getAmount();
            } else {
                throw new IllegalArgumentException("The transaction passed in has an invalid type: " + (Object)((Object)aTransaction.getType()));
            }
        }
    }

    protected void setCreatedBy(String aCreatedBy) {
        this._createdBy = aCreatedBy;
    }

    public String getCreatedBy() {
        return this._createdBy;
    }

    public Date getCreationDate() {
        return this._creationDate;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this._id).append("ownerName", (Object)this._ownerName).append("isActive", this._isActive).append("balance", this._balance).append("tx.count", this._transactions.size()).append("createdBy", (Object)this._createdBy).append("creationDate", (Object)new Timestamp(this._creationDate.getTime())).toString();
    }
}

