/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.samples.aspectj.bank;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class AccountTransaction {
    private static long _SEQUENCE;
    private long _id = ++_SEQUENCE;
    private TransactionType _type;
    private long _accountId;
    private double _amount;
    private String _createdBy;
    private Date _creationDate;

    public static AccountTransaction createDepositTx(long anAccountId, double anAmount) {
        return new AccountTransaction(TransactionType.DEPOSIT, anAccountId, anAmount);
    }

    public static AccountTransaction createWithdrawalTx(long anAccountId, double anAmount) {
        return new AccountTransaction(TransactionType.WITHDRAWAL, anAccountId, anAmount);
    }

    private AccountTransaction(TransactionType aType, long anAccountId, double anAmount) {
        this._type = aType;
        this._accountId = anAccountId;
        this._amount = anAmount;
        this._createdBy = "unknown";
        this._creationDate = new Date();
    }

    public long getId() {
        return this._id;
    }

    public TransactionType getType() {
        return this._type;
    }

    public long getAccountId() {
        return this._accountId;
    }

    public double getAmount() {
        return this._amount;
    }

    protected void setCreatedBy(String aCreatedBy) {
        this._createdBy = aCreatedBy;
    }

    public String getCreatedBy() {
        return this._createdBy;
    }

    public Date getCreationDate() {
        return this._creationDate;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this._id).append("type", (Object)this._type).append("accountId", this._accountId).append("amount", this._amount).append("createdBy", (Object)this._createdBy).append("creationDate", (Object)new Timestamp(this._creationDate.getTime())).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransactionType {
        DEPOSIT,
        WITHDRAWAL;

    }
}

