/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.samples.aspectj.bank;

import java.util.Date;
import org.apache.shiro.samples.aspectj.bank.AccountNotFoundException;
import org.apache.shiro.samples.aspectj.bank.InactiveAccountException;
import org.apache.shiro.samples.aspectj.bank.NotEnoughFundsException;

public interface BankService {
    public long[] searchAccountIdsByOwner(String var1);

    public long createNewAccount(String var1);

    public double getBalanceOf(long var1) throws AccountNotFoundException;

    public String getOwnerOf(long var1) throws AccountNotFoundException;

    public double depositInto(long var1, double var3) throws AccountNotFoundException, InactiveAccountException;

    public double withdrawFrom(long var1, double var3) throws AccountNotFoundException, NotEnoughFundsException, InactiveAccountException;

    public TxLog[] getTxHistoryFor(long var1) throws AccountNotFoundException;

    public double closeAccount(long var1) throws AccountNotFoundException, InactiveAccountException;

    public boolean isAccountActive(long var1) throws AccountNotFoundException;

    public static class TxLog {
        private Date _creationDate;
        private double _amount;
        private String _madeBy;

        public TxLog(Date aCreationDate, double aAmount, String aMadeBy) {
            this._creationDate = aCreationDate;
            this._amount = aAmount;
            this._madeBy = aMadeBy;
        }

        public Date getCreationDate() {
            return this._creationDate;
        }

        public double getAmount() {
            return this._amount;
        }

        public String getMadeBy() {
            return this._madeBy;
        }
    }
}

