/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.samples.aspectj.bank;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.aspectj.ShiroAnnotationAuthorizingAspect;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.samples.aspectj.bank.Account;
import org.apache.shiro.samples.aspectj.bank.AccountNotFoundException;
import org.apache.shiro.samples.aspectj.bank.AccountTransaction;
import org.apache.shiro.samples.aspectj.bank.BankService;
import org.apache.shiro.samples.aspectj.bank.InactiveAccountException;
import org.apache.shiro.samples.aspectj.bank.NotEnoughFundsException;
import org.apache.shiro.subject.Subject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureBankService
implements BankService {
    private static final Logger log;
    private volatile boolean _isRunning;
    private final List<Account> _accounts = new ArrayList<Account>();
    private Map<Long, Account> _accountsById = new HashMap<Long, Account>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        SecureBankService.ajc$preClinit();
        log = LoggerFactory.getLogger(SecureBankService.class);
    }

    public void start() throws Exception {
        this._isRunning = true;
        log.info("Bank service started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        log.info("Stopping bank service...");
        this._isRunning = false;
        List<Account> list = this._accounts;
        synchronized (list) {
            this._accountsById.clear();
            this._accounts.clear();
        }
        log.info("Bank service stopped");
    }

    protected void assertServiceState() {
        if (!this._isRunning) {
            throw new IllegalStateException("This bank service is not running");
        }
    }

    public int getAccountCount() {
        return this._accounts.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"bankAccount:create"})
    public long createNewAccount(String string) {
        void anOwnerName;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
        ShiroAnnotationAuthorizingAspect.aspectOf().executeAnnotatedMethod(joinPoint);
        this.assertServiceState();
        log.info("Creating new account for " + (String)anOwnerName);
        List<Account> list = this._accounts;
        synchronized (list) {
            Account account = new Account((String)anOwnerName);
            account.setCreatedBy(this.getCurrentUsername());
            this._accounts.add(account);
            this._accountsById.put(account.getId(), account);
            log.debug("Created new account: " + account);
            return account.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] searchAccountIdsByOwner(String anOwnerName) {
        this.assertServiceState();
        log.info("Searching existing accounts for " + anOwnerName);
        ArrayList<Account> matchAccounts = new ArrayList<Account>();
        List<Account> list = this._accounts;
        synchronized (list) {
            for (Account a : this._accounts) {
                if (!a.getOwnerName().toLowerCase().contains(anOwnerName.toLowerCase())) continue;
                matchAccounts.add(a);
            }
        }
        long[] accountIds = new long[matchAccounts.size()];
        int index = 0;
        for (Account a : matchAccounts) {
            accountIds[index++] = a.getId();
        }
        log.debug("Found " + accountIds.length + " account(s) matching the name " + anOwnerName);
        return accountIds;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"bankAccount:read"})
    public String getOwnerOf(long l) throws AccountNotFoundException {
        void anAccountId;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        ShiroAnnotationAuthorizingAspect.aspectOf().executeAnnotatedMethod(joinPoint);
        this.assertServiceState();
        log.info("Getting owner of account " + (long)anAccountId);
        Account a = this.safellyRetrieveAccountForId((long)anAccountId);
        return a.getOwnerName();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"bankAccount:read"})
    public double getBalanceOf(long l) throws AccountNotFoundException {
        void anAccountId;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        ShiroAnnotationAuthorizingAspect.aspectOf().executeAnnotatedMethod(joinPoint);
        this.assertServiceState();
        log.info("Getting balance of account " + (long)anAccountId);
        Account a = this.safellyRetrieveAccountForId((long)anAccountId);
        return a.getBalance();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"bankAccount:operate"})
    public double depositInto(long l, double d) throws AccountNotFoundException, InactiveAccountException {
        void anAccountId;
        void anAmount;
        long l2 = l;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2), (Object)Conversions.doubleObject((double)d2));
        ShiroAnnotationAuthorizingAspect.aspectOf().executeAnnotatedMethod(joinPoint);
        this.assertServiceState();
        log.info("Making deposit of " + (double)anAmount + " into account " + (long)anAccountId);
        try {
            Account a = this.safellyRetrieveAccountForId((long)anAccountId);
            AccountTransaction tx = AccountTransaction.createDepositTx((long)anAccountId, (double)anAmount);
            tx.setCreatedBy(this.getCurrentUsername());
            log.debug("Created a new transaction " + tx);
            a.applyTransaction(tx);
            log.debug("New balance of account " + a.getId() + " after deposit is " + a.getBalance());
            return a.getBalance();
        }
        catch (NotEnoughFundsException nefe) {
            throw new IllegalStateException("Should never happen", nefe);
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"bankAccount:operate"})
    public double withdrawFrom(long l, double d) throws AccountNotFoundException, NotEnoughFundsException, InactiveAccountException {
        void anAccountId;
        void anAmount;
        long l2 = l;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2), (Object)Conversions.doubleObject((double)d2));
        ShiroAnnotationAuthorizingAspect.aspectOf().executeAnnotatedMethod(joinPoint);
        this.assertServiceState();
        log.info("Making withdrawal of " + (double)anAmount + " from account " + (long)anAccountId);
        Account a = this.safellyRetrieveAccountForId((long)anAccountId);
        AccountTransaction tx = AccountTransaction.createWithdrawalTx((long)anAccountId, (double)anAmount);
        tx.setCreatedBy(this.getCurrentUsername());
        log.debug("Created a new transaction " + tx);
        a.applyTransaction(tx);
        log.debug("New balance of account " + a.getId() + " after withdrawal is " + a.getBalance());
        return a.getBalance();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"bankAccount:read"})
    public BankService.TxLog[] getTxHistoryFor(long l) throws AccountNotFoundException {
        void anAccountId;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        ShiroAnnotationAuthorizingAspect.aspectOf().executeAnnotatedMethod(joinPoint);
        this.assertServiceState();
        log.info("Getting transactions of account " + (long)anAccountId);
        Account a = this.safellyRetrieveAccountForId((long)anAccountId);
        BankService.TxLog[] txs = new BankService.TxLog[a.getTransactions().size()];
        int index = 0;
        for (AccountTransaction tx : a.getTransactions()) {
            log.debug("Retrieved transaction " + tx);
            txs[index++] = AccountTransaction.TransactionType.DEPOSIT == tx.getType() ? new BankService.TxLog(tx.getCreationDate(), tx.getAmount(), tx.getCreatedBy()) : new BankService.TxLog(tx.getCreationDate(), -1.0 * tx.getAmount(), tx.getCreatedBy());
        }
        return txs;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"bankAccount:close"})
    public double closeAccount(long l) throws AccountNotFoundException, InactiveAccountException {
        void anAccountId;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        ShiroAnnotationAuthorizingAspect.aspectOf().executeAnnotatedMethod(joinPoint);
        this.assertServiceState();
        log.info("Closing account " + (long)anAccountId);
        Account a = this.safellyRetrieveAccountForId((long)anAccountId);
        if (!a.isActive()) {
            throw new InactiveAccountException("The account " + (long)anAccountId + " is already closed");
        }
        try {
            AccountTransaction tx = AccountTransaction.createWithdrawalTx(a.getId(), a.getBalance());
            tx.setCreatedBy(this.getCurrentUsername());
            log.debug("Created a new transaction " + tx);
            a.applyTransaction(tx);
            a.setActive(false);
            log.debug("Account " + a.getId() + " is now closed and an amount of " + tx.getAmount() + " is given to the owner");
            return tx.getAmount();
        }
        catch (NotEnoughFundsException nefe) {
            throw new IllegalStateException("Should never happen", nefe);
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"bankAccount:read"})
    public boolean isAccountActive(long l) throws AccountNotFoundException {
        void anAccountId;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        ShiroAnnotationAuthorizingAspect.aspectOf().executeAnnotatedMethod(joinPoint);
        this.assertServiceState();
        log.info("Getting active status of account " + (long)anAccountId);
        Account a = this.safellyRetrieveAccountForId((long)anAccountId);
        return a.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Account safellyRetrieveAccountForId(long anAccountId) throws AccountNotFoundException {
        Account account = null;
        List<Account> list = this._accounts;
        synchronized (list) {
            account = this._accountsById.get(anAccountId);
        }
        if (account == null) {
            throw new AccountNotFoundException("No account found for the id " + anAccountId);
        }
        log.info("Retrieved account " + account);
        return account;
    }

    protected String getCurrentUsername() {
        Subject subject = SecurityUtils.getSubject();
        if (subject == null || subject.getPrincipal() == null || !subject.isAuthenticated()) {
            throw new IllegalStateException("Unable to retrieve the current authenticated subject");
        }
        return SecurityUtils.getSubject().getPrincipal().toString();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SecureBankService.java", SecureBankService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createNewAccount", "org.apache.shiro.samples.aspectj.bank.SecureBankService", "java.lang.String", "anOwnerName", "", "long"), 89);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwnerOf", "org.apache.shiro.samples.aspectj.bank.SecureBankService", "long", "anAccountId", "org.apache.shiro.samples.aspectj.bank.AccountNotFoundException", "java.lang.String"), 136);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBalanceOf", "org.apache.shiro.samples.aspectj.bank.SecureBankService", "long", "anAccountId", "org.apache.shiro.samples.aspectj.bank.AccountNotFoundException", "double"), 149);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "depositInto", "org.apache.shiro.samples.aspectj.bank.SecureBankService", "long:double", "anAccountId:anAmount", "org.apache.shiro.samples.aspectj.bank.AccountNotFoundException:org.apache.shiro.samples.aspectj.bank.InactiveAccountException", "double"), 162);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withdrawFrom", "org.apache.shiro.samples.aspectj.bank.SecureBankService", "long:double", "anAccountId:anAmount", "org.apache.shiro.samples.aspectj.bank.AccountNotFoundException:org.apache.shiro.samples.aspectj.bank.NotEnoughFundsException:org.apache.shiro.samples.aspectj.bank.InactiveAccountException", "double"), 187);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTxHistoryFor", "org.apache.shiro.samples.aspectj.bank.SecureBankService", "long", "anAccountId", "org.apache.shiro.samples.aspectj.bank.AccountNotFoundException", "[Lorg.apache.shiro.samples.aspectj.bank.BankService$TxLog;"), 207);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeAccount", "org.apache.shiro.samples.aspectj.bank.SecureBankService", "long", "anAccountId", "org.apache.shiro.samples.aspectj.bank.AccountNotFoundException:org.apache.shiro.samples.aspectj.bank.InactiveAccountException", "double"), 233);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAccountActive", "org.apache.shiro.samples.aspectj.bank.SecureBankService", "long", "anAccountId", "org.apache.shiro.samples.aspectj.bank.AccountNotFoundException", "boolean"), 262);
    }
}

