/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.jaxrs;

import java.security.Principal;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;

public class ShiroSecurityContext
implements SecurityContext {
    private final ContainerRequestContext containerRequestContext;
    private final SecurityContext originalSecurityContext;

    public ShiroSecurityContext(ContainerRequestContext containerRequestContext) {
        this.containerRequestContext = containerRequestContext;
        this.originalSecurityContext = containerRequestContext.getSecurityContext();
    }

    public Principal getUserPrincipal() {
        Principal result;
        Subject subject = this.getSubject();
        PrincipalCollection shiroPrincipals = subject.getPrincipals();
        if (shiroPrincipals != null) {
            result = (Principal)shiroPrincipals.oneByType(Principal.class);
            if (result == null) {
                result = new ObjectPrincipal(shiroPrincipals.getPrimaryPrincipal());
            }
        } else {
            result = this.originalSecurityContext.getUserPrincipal();
        }
        return result;
    }

    public boolean isUserInRole(String role) {
        return this.getSubject().hasRole(role);
    }

    public boolean isSecure() {
        return this.containerRequestContext.getSecurityContext().isSecure();
    }

    public String getAuthenticationScheme() {
        return this.containerRequestContext.getSecurityContext().getAuthenticationScheme();
    }

    private Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    private class ObjectPrincipal
    implements Principal {
        private Object object = null;

        public ObjectPrincipal(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        @Override
        public String getName() {
            return this.getObject().toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectPrincipal that = (ObjectPrincipal)o;
            return this.object.equals(that.object);
        }

        @Override
        public int hashCode() {
            return this.object.hashCode();
        }

        @Override
        public String toString() {
            return this.object.toString();
        }
    }
}

