/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.web.servlet.NameableFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OncePerRequestFilter
extends NameableFilter {
    private static final Logger log = LoggerFactory.getLogger(OncePerRequestFilter.class);
    public static final String ALREADY_FILTERED_SUFFIX = ".FILTERED";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String alreadyFilteredAttributeName = this.getAlreadyFilteredAttributeName();
        if (request.getAttribute(alreadyFilteredAttributeName) != null || this.shouldNotFilter(request)) {
            log.trace("Filter '{}' already executed.  Proceeding without invoking this filter.", (Object)this.getName());
            filterChain.doFilter(request, response);
        } else {
            log.trace("Filter '{}' not yet executed.  Executing now.", (Object)this.getName());
            request.setAttribute(alreadyFilteredAttributeName, (Object)Boolean.TRUE);
            try {
                this.doFilterInternal(request, response, filterChain);
            }
            finally {
                request.removeAttribute(alreadyFilteredAttributeName);
            }
        }
    }

    protected String getAlreadyFilteredAttributeName() {
        String name = this.getName();
        if (name == null) {
            name = this.getClass().getName();
        }
        return name + ALREADY_FILTERED_SUFFIX;
    }

    protected boolean shouldNotFilter(ServletRequest request) throws ServletException {
        return false;
    }

    protected abstract void doFilterInternal(ServletRequest var1, ServletResponse var2, FilterChain var3) throws ServletException, IOException;
}

