/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.noggit.JSONWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.HashPartitioner;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.zookeeper.KeeperException;

public class CloudState
implements JSONWriter.Writable {
    private final Map<String, Map<String, Slice>> collectionStates;
    private final Set<String> liveNodes;
    private final HashPartitioner hp = new HashPartitioner();
    private final Map<String, RangeInfo> rangeInfos = new HashMap<String, RangeInfo>();
    private final Map<String, Map<String, ZkNodeProps>> leaders = new HashMap<String, Map<String, ZkNodeProps>>();

    public CloudState(Set<String> liveNodes, Map<String, Map<String, Slice>> collectionStates) {
        this.liveNodes = new HashSet<String>(liveNodes.size());
        this.liveNodes.addAll(liveNodes);
        this.collectionStates = new HashMap<String, Map<String, Slice>>(collectionStates.size());
        this.collectionStates.putAll(collectionStates);
        this.addRangeInfos(collectionStates.keySet());
        this.getShardLeaders();
    }

    private void getShardLeaders() {
        Set<Map.Entry<String, Map<String, Slice>>> collections = this.collectionStates.entrySet();
        for (Map.Entry<String, Map<String, Slice>> collection : collections) {
            Map<String, Slice> state = collection.getValue();
            Set<Map.Entry<String, Slice>> slices = state.entrySet();
            for (Map.Entry<String, Slice> sliceEntry : slices) {
                Slice slice = sliceEntry.getValue();
                Map<String, ZkNodeProps> shards = slice.getShards();
                Set<Map.Entry<String, ZkNodeProps>> shardsEntries = shards.entrySet();
                for (Map.Entry<String, ZkNodeProps> shardEntry : shardsEntries) {
                    ZkNodeProps props = shardEntry.getValue();
                    if (!props.containsKey("leader")) continue;
                    Map<String, ZkNodeProps> leadersForCollection = this.leaders.get(collection.getKey());
                    if (leadersForCollection == null) {
                        leadersForCollection = new HashMap<String, ZkNodeProps>();
                        this.leaders.put(collection.getKey(), leadersForCollection);
                    }
                    leadersForCollection.put(sliceEntry.getKey(), props);
                }
            }
        }
    }

    public ZkNodeProps getLeader(String collection, String shard) {
        Map<String, ZkNodeProps> collectionLeaders = this.leaders.get(collection);
        if (collectionLeaders == null) {
            return null;
        }
        return collectionLeaders.get(shard);
    }

    public ZkNodeProps getShardProps(String collection, String coreNodeName) {
        Map<String, Slice> slices = this.getSlices(collection);
        for (Slice slice : slices.values()) {
            if (slice.getShards().get(coreNodeName) == null) continue;
            return slice.getShards().get(coreNodeName);
        }
        return null;
    }

    private void addRangeInfos(Set<String> collections) {
        for (String collection : collections) {
            this.addRangeInfo(collection);
        }
    }

    public Slice getSlice(String collection, String slice) {
        if (this.collectionStates.containsKey(collection) && this.collectionStates.get(collection).containsKey(slice)) {
            return this.collectionStates.get(collection).get(slice);
        }
        return null;
    }

    public Map<String, Slice> getSlices(String collection) {
        if (!this.collectionStates.containsKey(collection)) {
            return null;
        }
        return Collections.unmodifiableMap(this.collectionStates.get(collection));
    }

    public Set<String> getCollections() {
        return Collections.unmodifiableSet(this.collectionStates.keySet());
    }

    public Map<String, Map<String, Slice>> getCollectionStates() {
        return Collections.unmodifiableMap(this.collectionStates);
    }

    public Set<String> getLiveNodes() {
        return Collections.unmodifiableSet(this.liveNodes);
    }

    public String getShardId(String coreNodeName) {
        for (Map.Entry<String, Map<String, Slice>> states : this.collectionStates.entrySet()) {
            for (Map.Entry<String, Slice> slices : states.getValue().entrySet()) {
                for (Map.Entry<String, ZkNodeProps> shards : slices.getValue().getShards().entrySet()) {
                    if (!coreNodeName.equals(shards.getKey())) continue;
                    return slices.getKey();
                }
            }
        }
        return null;
    }

    public boolean liveNodesContain(String name) {
        return this.liveNodes.contains(name);
    }

    public RangeInfo getRanges(String collection) {
        RangeInfo rangeInfo = this.rangeInfos.get(collection);
        return rangeInfo;
    }

    private RangeInfo addRangeInfo(String collection) {
        RangeInfo rangeInfo = new RangeInfo();
        Map<String, Slice> slices = this.getSlices(collection);
        if (slices == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not find collection " + collection + " in " + this);
        }
        Set<String> shards = slices.keySet();
        ArrayList<String> shardList = new ArrayList<String>(shards.size());
        shardList.addAll(shards);
        Collections.sort(shardList);
        List<HashPartitioner.Range> ranges = this.hp.partitionRange(shards.size());
        rangeInfo.ranges = ranges;
        rangeInfo.shardList = shardList;
        this.rangeInfos.put(collection, rangeInfo);
        return rangeInfo;
    }

    public String getShard(int hash, String collection) {
        RangeInfo rangInfo = this.getRanges(collection);
        int cnt = 0;
        for (HashPartitioner.Range range : rangInfo.ranges) {
            if ((long)hash < range.max) {
                return (String)rangInfo.shardList.get(cnt);
            }
            ++cnt;
        }
        throw new IllegalStateException("The HashPartitioner failed");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("live nodes:" + this.liveNodes);
        sb.append(" collections:" + this.collectionStates);
        return sb.toString();
    }

    public static CloudState load(SolrZkClient zkClient, Set<String> liveNodes) throws KeeperException, InterruptedException {
        byte[] state = zkClient.getData("/clusterstate.json", null, null, true);
        return CloudState.load(state, liveNodes);
    }

    public static CloudState load(byte[] bytes, Set<String> liveNodes) throws KeeperException, InterruptedException {
        if (bytes == null || bytes.length == 0) {
            return new CloudState(liveNodes, Collections.<String, Map<String, Slice>>emptyMap());
        }
        LinkedHashMap stateMap = (LinkedHashMap)ZkStateReader.fromJSON(bytes);
        HashMap<String, Map<String, Slice>> state = new HashMap<String, Map<String, Slice>>();
        for (String collectionName : stateMap.keySet()) {
            Map collection = (Map)stateMap.get(collectionName);
            LinkedHashMap<String, Slice> slices = new LinkedHashMap<String, Slice>();
            for (String sliceName : collection.keySet()) {
                Map sliceMap = (Map)collection.get(sliceName);
                LinkedHashMap<String, ZkNodeProps> shards = new LinkedHashMap<String, ZkNodeProps>();
                for (String shardName : sliceMap.keySet()) {
                    shards.put(shardName, new ZkNodeProps((Map)sliceMap.get(shardName)));
                }
                Slice slice = new Slice(sliceName, shards);
                slices.put(sliceName, slice);
            }
            state.put(collectionName, slices);
        }
        return new CloudState(liveNodes, state);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this.collectionStates);
    }

    private class RangeInfo {
        private List<HashPartitioner.Range> ranges;
        private ArrayList<String> shardList;

        private RangeInfo() {
        }
    }
}

