/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.noggit.JSONWriter;
import org.apache.solr.common.cloud.ZkNodeProps;

public class Slice
implements JSONWriter.Writable {
    private final Map<String, ZkNodeProps> shards;
    private final String name;

    public Slice(String name, Map<String, ZkNodeProps> shards) {
        this.shards = shards;
        this.name = name;
    }

    public Map<String, ZkNodeProps> getShards() {
        return Collections.unmodifiableMap(this.shards);
    }

    public Map<String, ZkNodeProps> getShardsCopy() {
        HashMap<String, ZkNodeProps> shards = new HashMap<String, ZkNodeProps>();
        for (Map.Entry<String, ZkNodeProps> entry : this.shards.entrySet()) {
            ZkNodeProps zkProps = new ZkNodeProps(entry.getValue());
            shards.put(entry.getKey(), zkProps);
        }
        return shards;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Slice [shards=" + this.shards + ", name=" + this.name + "]";
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this.shards);
    }
}

