/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import org.apache.solr.common.util.ContentStream;

public abstract class ContentStreamBase
implements ContentStream {
    public static final String DEFAULT_CHARSET = "utf-8";
    protected String name;
    protected String sourceInfo;
    protected String contentType;
    protected Long size;

    public static String getCharsetFromContentType(String contentType) {
        int idx;
        if (contentType != null && (idx = contentType.toLowerCase(Locale.ROOT).indexOf("charset=")) > 0) {
            return contentType.substring(idx + "charset=".length()).trim();
        }
        return null;
    }

    @Override
    public Reader getReader() throws IOException {
        String charset = ContentStreamBase.getCharsetFromContentType(this.getContentType());
        return charset == null ? new InputStreamReader(this.getStream(), DEFAULT_CHARSET) : new InputStreamReader(this.getStream(), charset);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @Override
    public String getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(String sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public static class StringStream
    extends ContentStreamBase {
        private final String str;

        public StringStream(String str) {
            this.str = str;
            this.contentType = null;
            this.name = null;
            this.size = new Long(str.length());
            this.sourceInfo = "string";
        }

        @Override
        public String getContentType() {
            if (this.contentType == null && this.str.length() > 0) {
                char first = this.str.charAt(0);
                if (first == '<') {
                    return "application/xml";
                }
                if (first == '{') {
                    return "application/json";
                }
            }
            return this.contentType;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.str.getBytes(ContentStreamBase.DEFAULT_CHARSET));
        }

        @Override
        public Reader getReader() throws IOException {
            String charset = StringStream.getCharsetFromContentType(this.contentType);
            return charset == null ? new StringReader(this.str) : new InputStreamReader(this.getStream(), charset);
        }
    }

    public static class FileStream
    extends ContentStreamBase {
        private final File file;

        public FileStream(File f) {
            this.file = f;
            this.contentType = null;
            this.name = this.file.getName();
            this.size = this.file.length();
            this.sourceInfo = this.file.toURI().toString();
        }

        @Override
        public String getContentType() {
            if (this.contentType == null) {
                try {
                    char first = (char)new FileInputStream(this.file).read();
                    if (first == '<') {
                        return "application/xml";
                    }
                    if (first == '{') {
                        return "application/json";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.contentType;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public Reader getReader() throws IOException {
            String charset = FileStream.getCharsetFromContentType(this.contentType);
            return charset == null ? new InputStreamReader(this.getStream(), "UTF-8") : new InputStreamReader(this.getStream(), charset);
        }
    }

    public static class URLStream
    extends ContentStreamBase {
        private final URL url;

        public URLStream(URL url) {
            this.url = url;
            this.sourceInfo = "url";
        }

        @Override
        public InputStream getStream() throws IOException {
            URLConnection conn = this.url.openConnection();
            this.contentType = conn.getContentType();
            this.name = this.url.toExternalForm();
            this.size = new Long(conn.getContentLength());
            return conn.getInputStream();
        }
    }
}

