/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.SelectionKey;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class SolrZooKeeper
extends ZooKeeper {
    final Set<Thread> spawnedThreads = new CopyOnWriteArraySet<Thread>();

    public SolrZooKeeper(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
        super(connectString, sessionTimeout, watcher);
    }

    public ClientCnxn getConnection() {
        return this.cnxn;
    }

    public void pauseCnxn(final long ms) {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ClientCnxn cnxn;
                    ClientCnxn clientCnxn = cnxn = SolrZooKeeper.this.getConnection();
                    synchronized (clientCnxn) {
                        try {
                            Field sendThreadFld = cnxn.getClass().getDeclaredField("sendThread");
                            sendThreadFld.setAccessible(true);
                            Object sendThread = sendThreadFld.get(cnxn);
                            if (sendThread != null) {
                                Field sockKeyFld = sendThread.getClass().getDeclaredField("sockKey");
                                sockKeyFld.setAccessible(true);
                                SelectionKey sockKey = (SelectionKey)sockKeyFld.get(sendThread);
                                if (sockKey != null) {
                                    sockKey.channel().close();
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Closing Zookeeper send channel failed.", e);
                        }
                        Thread.sleep(ms);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    SolrZooKeeper.this.spawnedThreads.remove(this);
                }
            }
        };
        this.spawnedThreads.add(t);
        t.start();
    }

    public synchronized void close() throws InterruptedException {
        for (Thread t : this.spawnedThreads) {
            if (!t.isAlive()) continue;
            t.interrupt();
        }
        super.close();
    }
}

