/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.common.cloud.UrlScheme;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.Utils;
import org.noggit.JSONWriter;

public class ZkNodeProps
implements JSONWriter.Writable {
    protected final Map<String, Object> propMap;

    public ZkNodeProps(Map<String, Object> propMap) {
        this.propMap = propMap;
        if (this.propMap.containsKey("node_name")) {
            this.propMap.remove("base_url");
        }
    }

    public ZkNodeProps plus(String key, Object val) {
        return this.plus(Collections.singletonMap(key, val));
    }

    public ZkNodeProps plus(Map<String, Object> newVals) {
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(this.propMap);
        if (newVals == null || newVals.isEmpty()) {
            return new ZkNodeProps(copy);
        }
        copy.putAll(newVals);
        return new ZkNodeProps(copy);
    }

    public ZkNodeProps(String ... keyVals) {
        this(Utils.makeMap(keyVals));
    }

    public static ZkNodeProps fromKeyVals(Object ... keyVals) {
        return new ZkNodeProps(Utils.makeMap(keyVals));
    }

    public Set<String> keySet() {
        return this.propMap.keySet();
    }

    public Map<String, Object> getProperties() {
        return this.propMap;
    }

    public Map<String, Object> shallowCopy() {
        return new LinkedHashMap<String, Object>(this.propMap);
    }

    public static ZkNodeProps load(byte[] bytes) {
        Map props;
        block15: {
            if (bytes[0] == 2) {
                try (JavaBinCodec jbc = new JavaBinCodec();){
                    props = (Map)jbc.unmarshal(bytes);
                    break block15;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to parse javabin content");
                }
            }
            props = (Map)Utils.fromJSON(bytes);
        }
        return new ZkNodeProps(props);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        if (this.propMap.containsKey("base_url") && this.propMap.containsKey("node_name")) {
            HashMap filtered = new HashMap();
            this.propMap.forEach((key, value) -> {
                if (!"base_url".equals(key)) {
                    filtered.put(key, value);
                }
            });
            jsonWriter.write(filtered);
        } else {
            jsonWriter.write(this.propMap);
        }
    }

    public String getStr(String key) {
        return this.getStr(key, null);
    }

    public Integer getInt(String key, Integer def) {
        Object o = this.propMap.get(key);
        return o == null ? def : Integer.valueOf(o.toString());
    }

    public String getStr(String key, String def) {
        String nodeName;
        Object o = this.propMap.get(key);
        if (o == null && def == null && "base_url".equals(key) && (nodeName = (String)this.propMap.get("node_name")) != null) {
            o = UrlScheme.INSTANCE.getBaseUrlForNodeName(nodeName);
        }
        return o == null ? def : o.toString();
    }

    public Object get(String key) {
        return this.propMap.get(key);
    }

    public String toString() {
        return Utils.toJSONString(this);
    }

    public boolean containsKey(String key) {
        return this.propMap.containsKey(key);
    }

    public boolean getBool(String key, boolean b) {
        Object o = this.propMap.get(key);
        if (o == null) {
            return b;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean(o.toString());
    }

    public boolean equals(Object that) {
        return that instanceof ZkNodeProps && ((ZkNodeProps)that).propMap.equals(this.propMap);
    }

    public int hashCode() {
        return Objects.hashCode(this.propMap);
    }
}

