/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.tests.analysis.MockTokenFilter;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;

public class MockTokenFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "mock";
    final CharacterRunAutomaton filter;

    public MockTokenFilterFactory(Map<String, String> args) {
        super(args);
        String stopset = this.get(args, "stopset", Arrays.asList("english", "empty"), null, false);
        String stopregex = this.get(args, "stopregex");
        if (null != stopset) {
            if (null != stopregex) {
                throw new IllegalArgumentException("Parameters stopset and stopregex cannot both be specified.");
            }
            this.filter = "english".equalsIgnoreCase(stopset) ? MockTokenFilter.ENGLISH_STOPSET : MockTokenFilter.EMPTY_STOPSET;
        } else if (null != stopregex) {
            RegExp regex = new RegExp(stopregex);
            this.filter = new CharacterRunAutomaton(regex.toAutomaton());
        } else {
            throw new IllegalArgumentException("Configuration Error: either the 'stopset' or the 'stopregex' parameter must be specified.");
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public MockTokenFilterFactory() {
        throw MockTokenFilterFactory.defaultCtorException();
    }

    public MockTokenFilter create(TokenStream stream) {
        return new MockTokenFilter(stream, this.filter);
    }
}

