/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.cluster.Cluster;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.Shard;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.AttributeFetcher;
import org.apache.solr.cluster.placement.AttributeFetcherForTest;
import org.apache.solr.cluster.placement.AttributeValues;
import org.apache.solr.cluster.placement.BalancePlanFactory;
import org.apache.solr.cluster.placement.ClusterAbstractionsForTest;
import org.apache.solr.cluster.placement.CollectionMetrics;
import org.apache.solr.cluster.placement.NodeMetric;
import org.apache.solr.cluster.placement.PlacementContext;
import org.apache.solr.cluster.placement.PlacementPlanFactory;
import org.apache.solr.cluster.placement.ReplicaMetric;
import org.apache.solr.cluster.placement.impl.AttributeFetcherImpl;
import org.apache.solr.cluster.placement.impl.AttributeValuesImpl;
import org.apache.solr.cluster.placement.impl.BalancePlanFactoryImpl;
import org.apache.solr.cluster.placement.impl.CollectionMetricsBuilder;
import org.apache.solr.cluster.placement.impl.NodeMetricImpl;
import org.apache.solr.cluster.placement.impl.PlacementPlanFactoryImpl;
import org.apache.solr.cluster.placement.impl.ReplicaMetricImpl;
import org.apache.solr.common.util.Pair;
import org.junit.Assert;

public class Builders {
    public static ClusterBuilder newClusterBuilder() {
        return new ClusterBuilder();
    }

    public static CollectionBuilder newCollectionBuilder(String collectionName) {
        return new CollectionBuilder(collectionName);
    }

    public static class NodeBuilder {
        private String nodeName = null;
        private Integer coreCount = null;
        private Double freeDiskGB = null;
        private Double totalDiskGB = null;
        private Map<String, String> sysprops = null;
        private Map<NodeMetric<?>, Object> metrics = null;

        public NodeBuilder setNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public NodeBuilder setCoreCount(Integer coreCount) {
            this.coreCount = coreCount;
            return this;
        }

        public NodeBuilder setFreeDiskGB(Double freeDiskGB) {
            this.freeDiskGB = freeDiskGB;
            return this;
        }

        public NodeBuilder setTotalDiskGB(Double totalDiskGB) {
            this.totalDiskGB = totalDiskGB;
            return this;
        }

        public NodeBuilder setSysprop(String key, String value) {
            if (this.sysprops == null) {
                this.sysprops = new HashMap<String, String>();
            }
            String name = AttributeFetcherImpl.getSystemPropertySnitchTag((String)key);
            this.sysprops.put(name, value);
            return this;
        }

        public NodeBuilder setMetric(NodeMetric<?> metric, Object value) {
            if (this.metrics == null) {
                this.metrics = new HashMap();
            }
            this.metrics.put(metric, metric.convert(value));
            return this;
        }

        public Integer getCoreCount() {
            return this.coreCount;
        }

        public Double getFreeDiskGB() {
            return this.freeDiskGB;
        }

        public Double getTotalDiskGB() {
            return this.totalDiskGB;
        }

        public Map<String, String> getSysprops() {
            return this.sysprops;
        }

        public Map<NodeMetric<?>, Object> getMetrics() {
            return this.metrics;
        }

        public Node build() {
            return new ClusterAbstractionsForTest.NodeImpl(this.nodeName);
        }
    }

    public static class ReplicaBuilder {
        private String replicaName;
        private String coreName;
        private Replica.ReplicaType replicaType;
        private Replica.ReplicaState replicaState;
        private NodeBuilder replicaNode;
        private Map<ReplicaMetric<?>, Object> metrics;

        public ReplicaBuilder setReplicaName(String replicaName) {
            this.replicaName = replicaName;
            return this;
        }

        public ReplicaBuilder setCoreName(String coreName) {
            this.coreName = coreName;
            return this;
        }

        public Replica.ReplicaType getReplicaType() {
            return this.replicaType;
        }

        public ReplicaBuilder setReplicaType(Replica.ReplicaType replicaType) {
            this.replicaType = replicaType;
            return this;
        }

        public ReplicaBuilder setReplicaState(Replica.ReplicaState replicaState) {
            this.replicaState = replicaState;
            return this;
        }

        public ReplicaBuilder setReplicaNode(NodeBuilder replicaNode) {
            this.replicaNode = replicaNode;
            return this;
        }

        public ReplicaBuilder setReplicaMetric(ReplicaMetric<?> metric, Object value) {
            if (this.metrics == null) {
                this.metrics = new HashMap();
            }
            this.metrics.put(metric, metric.convert(value));
            return this;
        }

        public Replica build(Shard shard) {
            return new ClusterAbstractionsForTest.ReplicaImpl(this.replicaName, this.coreName, shard, this.replicaType, this.replicaState, this.replicaNode.build());
        }
    }

    public static class ShardBuilder {
        private String shardName;
        private List<ReplicaBuilder> replicaBuilders = new ArrayList<ReplicaBuilder>();
        private ReplicaBuilder leaderReplicaBuilder;

        public ShardBuilder setShardName(String shardName) {
            this.shardName = shardName;
            return this;
        }

        public String getShardName() {
            return this.shardName;
        }

        public List<ReplicaBuilder> getReplicaBuilders() {
            return this.replicaBuilders;
        }

        public ShardBuilder setReplicaBuilders(List<ReplicaBuilder> replicaBuilders) {
            this.replicaBuilders = replicaBuilders;
            return this;
        }

        public ShardBuilder setLeader(ReplicaBuilder leaderReplicaBuilder) {
            this.leaderReplicaBuilder = leaderReplicaBuilder;
            return this;
        }

        public Shard build(SolrCollection collection) {
            ClusterAbstractionsForTest.ShardImpl shard = new ClusterAbstractionsForTest.ShardImpl(this.shardName, collection, Shard.ShardState.ACTIVE);
            LinkedHashMap<String, Replica> replicas = new LinkedHashMap<String, Replica>();
            Replica leader = null;
            for (ReplicaBuilder replicaBuilder : this.replicaBuilders) {
                Replica replica = replicaBuilder.build(shard);
                replicas.put(replica.getReplicaName(), replica);
                if (this.leaderReplicaBuilder != replicaBuilder) continue;
                leader = replica;
            }
            shard.setReplicas(replicas, leader);
            return shard;
        }
    }

    public static class CollectionBuilder {
        private final String collectionName;
        private List<ShardBuilder> shardBuilders = new ArrayList<ShardBuilder>();
        private Map<String, String> customProperties = new HashMap<String, String>();
        int replicaNumber = 0;
        private CollectionMetricsBuilder collectionMetricsBuilder = new CollectionMetricsBuilder();

        public CollectionBuilder(String collectionName) {
            this.collectionName = collectionName;
        }

        public CollectionBuilder addCustomProperty(String name, String value) {
            this.customProperties.put(name, value);
            return this;
        }

        public CollectionMetricsBuilder getCollectionMetricsBuilder() {
            return this.collectionMetricsBuilder;
        }

        public List<ShardBuilder> getShardBuilders() {
            return this.shardBuilders;
        }

        public CollectionBuilder customCollectionSetup(List<List<String>> shardsReplicas, List<NodeBuilder> liveNodes) {
            this.shardBuilders = new ArrayList<ShardBuilder>();
            int shardNumber = 1;
            for (List<String> replicasOnNodes : shardsReplicas) {
                String shardName = this.buildShardName(shardNumber++);
                ArrayList<ReplicaBuilder> replicas = new ArrayList<ReplicaBuilder>();
                ReplicaBuilder leader = null;
                for (String replicaNode : replicasOnNodes) {
                    String[] split = replicaNode.split("\\s+");
                    Assert.assertEquals((long)2L, (long)split.length);
                    Replica.ReplicaType type = Replica.ReplicaType.valueOf((String)split[0]);
                    int nodeIndex = Integer.parseInt(split[1]);
                    NodeBuilder node = nodeIndex < liveNodes.size() ? liveNodes.get(nodeIndex) : new NodeBuilder().setNodeName("NonLiveNode");
                    String replicaName = this.buildReplicaName(shardName, type);
                    ReplicaBuilder replicaBuilder = new ReplicaBuilder();
                    replicaBuilder.setReplicaName(replicaName).setCoreName(this.buildCoreName(replicaName)).setReplicaType(type).setReplicaState(Replica.ReplicaState.ACTIVE).setReplicaNode(node);
                    replicas.add(replicaBuilder);
                    if (leader != null || type == Replica.ReplicaType.PULL) continue;
                    leader = replicaBuilder;
                }
                ShardBuilder shardBuilder = new ShardBuilder();
                shardBuilder.setShardName(shardName).setReplicaBuilders(replicas).setLeader(leader);
                this.shardBuilders.add(shardBuilder);
            }
            return this;
        }

        public CollectionBuilder initializeShardsReplicas(int countShards, int countNrtReplicas, int countTlogReplicas, int countPullReplicas, List<NodeBuilder> nodes) {
            return this.initializeShardsReplicas(countShards, countNrtReplicas, countTlogReplicas, countPullReplicas, nodes, null);
        }

        public CollectionBuilder initializeShardsReplicas(int countShards, int countNrtReplicas, int countTlogReplicas, int countPullReplicas, List<NodeBuilder> nodes, List<Integer> initialSizeGBPerShard) {
            Iterator<NodeBuilder> nodeIterator = nodes.iterator();
            this.shardBuilders = new ArrayList<ShardBuilder>();
            if (initialSizeGBPerShard != null && initialSizeGBPerShard.size() != countShards) {
                throw new RuntimeException("list of shard sizes must be the same length as the countShards!");
            }
            for (int shardNumber = 1; shardNumber <= countShards; ++shardNumber) {
                String shardName = this.buildShardName(shardNumber);
                CollectionMetricsBuilder.ShardMetricsBuilder shardMetricsBuilder = new CollectionMetricsBuilder.ShardMetricsBuilder(shardName);
                ArrayList<ReplicaBuilder> replicas = new ArrayList<ReplicaBuilder>();
                ReplicaBuilder leader = null;
                CollectionMetricsBuilder.ReplicaMetricsBuilder leaderMetrics = null;
                List<Pair> replicaTypes = List.of(new Pair((Object)Replica.ReplicaType.NRT, (Object)countNrtReplicas), new Pair((Object)Replica.ReplicaType.TLOG, (Object)countTlogReplicas), new Pair((Object)Replica.ReplicaType.PULL, (Object)countPullReplicas));
                for (Pair tc : replicaTypes) {
                    Replica.ReplicaType type = (Replica.ReplicaType)tc.first();
                    int count = (Integer)tc.second();
                    for (int r = 0; r < count; ++r) {
                        if (!nodeIterator.hasNext()) {
                            nodeIterator = nodes.iterator();
                        }
                        NodeBuilder node = nodeIterator.next();
                        String replicaName = this.buildReplicaName(shardName, type);
                        ReplicaBuilder replicaBuilder = new ReplicaBuilder();
                        replicaBuilder.setReplicaName(replicaName).setCoreName(this.buildCoreName(replicaName)).setReplicaType(type).setReplicaState(Replica.ReplicaState.ACTIVE).setReplicaNode(node);
                        replicas.add(replicaBuilder);
                        CollectionMetricsBuilder.ReplicaMetricsBuilder replicaMetricsBuilder = new CollectionMetricsBuilder.ReplicaMetricsBuilder(replicaName);
                        shardMetricsBuilder.getReplicaMetricsBuilders().put(replicaName, replicaMetricsBuilder);
                        if (initialSizeGBPerShard != null) {
                            replicaMetricsBuilder.addMetric((ReplicaMetric)ReplicaMetricImpl.INDEX_SIZE_GB, (Object)((double)initialSizeGBPerShard.get(shardNumber - 1).intValue() * 1.073741824E9));
                        }
                        if (leader != null || type == Replica.ReplicaType.PULL) continue;
                        leader = replicaBuilder;
                        leaderMetrics = replicaMetricsBuilder;
                    }
                }
                ShardBuilder shardBuilder = new ShardBuilder();
                shardBuilder.setShardName(shardName).setReplicaBuilders(replicas).setLeader(leader);
                shardMetricsBuilder.setLeaderMetrics(leaderMetrics);
                this.shardBuilders.add(shardBuilder);
                this.collectionMetricsBuilder.getShardMetricsBuilders().put(shardName, shardMetricsBuilder);
            }
            return this;
        }

        private String buildShardName(int shardIndex) {
            return "shard" + shardIndex;
        }

        private String buildReplicaName(String shardName, Replica.ReplicaType replicaType) {
            return this.collectionName + "_" + shardName + "_replica_" + replicaType.getSuffixChar() + this.replicaNumber++;
        }

        private String buildCoreName(String replicaName) {
            return replicaName + "_c";
        }

        public SolrCollection build() {
            ClusterAbstractionsForTest.SolrCollectionImpl solrCollection = new ClusterAbstractionsForTest.SolrCollectionImpl(this.collectionName, this.customProperties);
            LinkedHashMap<String, Shard> shards = new LinkedHashMap<String, Shard>();
            for (ShardBuilder shardBuilder : this.shardBuilders) {
                Shard shard = shardBuilder.build(solrCollection);
                shards.put(shard.getShardName(), shard);
            }
            solrCollection.setShards(shards);
            return solrCollection;
        }
    }

    public static class ClusterBuilder {
        private List<NodeBuilder> nodeBuilders = new ArrayList<NodeBuilder>();
        private final List<CollectionBuilder> collectionBuilders = new ArrayList<CollectionBuilder>();
        private static final PlacementPlanFactory PLACEMENT_PLAN_FACTORY = new PlacementPlanFactoryImpl();
        private static final BalancePlanFactory BALANCE_PLAN_FACTORY = new BalancePlanFactoryImpl();

        public ClusterBuilder initializeLiveNodes(int countNodes) {
            this.nodeBuilders = new ArrayList<NodeBuilder>();
            for (int n = 0; n < countNodes; ++n) {
                NodeBuilder nodeBuilder = new NodeBuilder().setNodeName("node_" + n);
                nodeBuilder.setTotalDiskGB(10000.0);
                nodeBuilder.setFreeDiskGB(5000.0);
                nodeBuilder.setCoreCount(0);
                this.nodeBuilders.add(nodeBuilder);
            }
            return this;
        }

        public List<NodeBuilder> getLiveNodeBuilders() {
            return this.nodeBuilders;
        }

        public ClusterBuilder addCollection(CollectionBuilder collectionBuilder) {
            this.collectionBuilders.add(collectionBuilder);
            return this;
        }

        public Cluster build() {
            return new ClusterAbstractionsForTest.ClusterImpl(new HashSet<Node>(this.buildLiveNodes()), this.buildClusterCollections());
        }

        public List<Node> buildLiveNodes() {
            ArrayList<Node> liveNodes = new ArrayList<Node>();
            for (NodeBuilder nodeBuilder : this.nodeBuilders) {
                liveNodes.add(nodeBuilder.build());
            }
            return liveNodes;
        }

        Map<String, SolrCollection> buildClusterCollections() {
            LinkedHashMap<String, SolrCollection> clusterCollections = new LinkedHashMap<String, SolrCollection>();
            for (CollectionBuilder collectionBuilder : this.collectionBuilders) {
                SolrCollection solrCollection = collectionBuilder.build();
                clusterCollections.put(solrCollection.getName(), solrCollection);
            }
            return clusterCollections;
        }

        public PlacementContext buildPlacementContext() {
            final Cluster cluster = this.build();
            final AttributeFetcher attributeFetcher = this.buildAttributeFetcher();
            return new PlacementContext(){

                public Cluster getCluster() {
                    return cluster;
                }

                public AttributeFetcher getAttributeFetcher() {
                    return attributeFetcher;
                }

                public PlacementPlanFactory getPlacementPlanFactory() {
                    return PLACEMENT_PLAN_FACTORY;
                }

                public BalancePlanFactory getBalancePlanFactory() {
                    return BALANCE_PLAN_FACTORY;
                }
            };
        }

        public AttributeFetcher buildAttributeFetcher() {
            HashMap sysprops = new HashMap();
            HashMap<NodeMetric, Map> metrics = new HashMap<NodeMetric, Map>();
            HashMap collectionMetrics = new HashMap();
            for (NodeBuilder nodeBuilder : this.nodeBuilders) {
                Node node = nodeBuilder.build();
                if (nodeBuilder.getCoreCount() != null) {
                    metrics.computeIfAbsent((NodeMetric)NodeMetricImpl.NUM_CORES, n -> new HashMap()).put(node, nodeBuilder.getCoreCount());
                }
                if (nodeBuilder.getFreeDiskGB() != null) {
                    metrics.computeIfAbsent((NodeMetric)NodeMetricImpl.FREE_DISK_GB, n -> new HashMap()).put(node, nodeBuilder.getFreeDiskGB());
                }
                if (nodeBuilder.getTotalDiskGB() != null) {
                    metrics.computeIfAbsent((NodeMetric)NodeMetricImpl.TOTAL_DISK_GB, n -> new HashMap()).put(node, nodeBuilder.getTotalDiskGB());
                }
                if (nodeBuilder.getSysprops() != null) {
                    nodeBuilder.getSysprops().forEach((name, value) -> sysprops.computeIfAbsent(name, n -> new HashMap()).put(node, value));
                }
                if (nodeBuilder.getMetrics() == null) continue;
                nodeBuilder.getMetrics().forEach((name, value) -> metrics.computeIfAbsent((NodeMetric)name, n -> new HashMap()).put(node, value));
            }
            if (!this.collectionBuilders.isEmpty()) {
                Map nodeToCoreCount = metrics.computeIfAbsent((NodeMetric)NodeMetricImpl.NUM_CORES, n -> new HashMap());
                Map nodeToFreeDisk = metrics.computeIfAbsent((NodeMetric)NodeMetricImpl.FREE_DISK_GB, n -> new HashMap());
                this.collectionBuilders.forEach(builder -> {
                    CollectionMetrics thisCollMetrics = builder.collectionMetricsBuilder.build();
                    collectionMetrics.put(builder.collectionName, thisCollMetrics);
                    SolrCollection collection = builder.build();
                    collection.iterator().forEachRemaining(shard -> shard.iterator().forEachRemaining(replica -> {
                        nodeToCoreCount.compute(replica.getNode(), (node, count) -> count == null ? 1 : ((Number)count).intValue() + 1);
                        double leaderDiskSpace = thisCollMetrics.getShardMetrics(shard.getShardName()).flatMap(m -> m.getReplicaMetrics(replica.getReplicaName())).flatMap(m -> m.getReplicaMetric((ReplicaMetric)ReplicaMetricImpl.INDEX_SIZE_GB)).orElse(0.0);
                        nodeToFreeDisk.computeIfPresent(replica.getNode(), (node, freeDisk) -> (Double)freeDisk - leaderDiskSpace);
                    }));
                });
            }
            AttributeValuesImpl attributeValues = new AttributeValuesImpl(sysprops, metrics, collectionMetrics);
            return new AttributeFetcherForTest((AttributeValues)attributeValues);
        }
    }
}

