/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.ExchangeRateProvider;

public class MockExchangeRateProvider
implements ExchangeRateProvider {
    private static Map<String, Double> map = new HashMap<String, Double>();
    private boolean gotArgs = false;
    private boolean gotLoader = false;

    public double getExchangeRate(String sourceCurrencyCode, String targetCurrencyCode) {
        if (sourceCurrencyCode.equals(targetCurrencyCode)) {
            return 1.0;
        }
        Double result = map.get(sourceCurrencyCode + "," + targetCurrencyCode);
        if (result == null) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No exchange rate found for the pair " + sourceCurrencyCode + "," + targetCurrencyCode);
        }
        return result;
    }

    public Set<String> listAvailableCurrencies() {
        Set<String> currenciesPairs = map.keySet();
        HashSet<String> returnSet = new HashSet<String>();
        for (String c : currenciesPairs) {
            String[] pairs = c.split(",");
            returnSet.add(pairs[0]);
            returnSet.add(pairs[1]);
        }
        return returnSet;
    }

    public boolean reload() throws SolrException {
        assert (this.gotArgs);
        assert (this.gotLoader);
        return true;
    }

    public void init(Map<String, String> args) {
        assert (args.get("foo").equals("bar"));
        this.gotArgs = true;
        args.remove("foo");
    }

    public void inform(ResourceLoader loader) throws SolrException {
        assert (loader != null);
        this.gotLoader = true;
        assert (this.gotArgs);
    }

    static {
        map.put("USD,EUR", 0.8);
        map.put("EUR,USD", 1.2);
        map.put("USD,NOK", 5.0);
        map.put("NOK,USD", 0.2);
        map.put("EUR,NOK", 10.0);
        map.put("NOK,EUR", 0.1);
    }
}

