/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.ml.feature.OneHotEncoderBase;
import org.apache.spark.ml.feature.OneHotEncoderCommon$;
import org.apache.spark.ml.feature.OneHotEncoderEstimator$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class OneHotEncoderBase$class {
    public static boolean getDropLast(OneHotEncoderBase $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$($this.dropLast()));
    }

    public static StructType validateAndTransformSchema(OneHotEncoderBase $this, StructType schema, boolean dropLast, boolean keepInvalid) {
        String[] outputColNames;
        String[] inputColNames = $this.$($this.inputCols());
        Predef$.MODULE$.require(inputColNames.length == (outputColNames = $this.$($this.outputCols())).length, (Function0)new Serializable($this, inputColNames, outputColNames){
            public static final long serialVersionUID = 0L;
            private final String[] inputColNames$2;
            private final String[] outputColNames$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of input columns ", " must be the same as the number of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.inputColNames$2.length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"output columns ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.outputColNames$1.length)}))).toString();
            }
            {
                this.inputColNames$2 = inputColNames$2;
                this.outputColNames$1 = outputColNames$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])inputColNames).foreach((Function1)new Serializable($this, schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$2;

            public final void apply(String x$1) {
                SchemaUtils$.MODULE$.checkNumericType(this.schema$2, x$1, SchemaUtils$.MODULE$.checkNumericType$default$3());
            }
            {
                this.schema$2 = schema$2;
            }
        });
        StructField[] inputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])$this.$($this.inputCols())).map((Function1)new Serializable($this, schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$2;

            public final StructField apply(String x$2) {
                return this.schema$2.apply(x$2);
            }
            {
                this.schema$2 = schema$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])inputFields).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])outputColNames), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable($this, dropLast, keepInvalid){
            public static final long serialVersionUID = 0L;
            private final boolean dropLast$3;
            private final boolean keepInvalid$4;

            public final StructField apply(Tuple2<StructField, String> x0$1) {
                Tuple2<StructField, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField inputField = (StructField)tuple2._1();
                    String outputColName = (String)tuple2._2();
                    StructField structField = OneHotEncoderCommon$.MODULE$.transformOutputColumnSchema(inputField, outputColName, this.dropLast$3, this.keepInvalid$4);
                    return structField;
                }
                throw new MatchError(tuple2);
            }
            {
                this.dropLast$3 = dropLast$3;
                this.keepInvalid$4 = keepInvalid$4;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return (StructType)Predef$.MODULE$.refArrayOps((Object[])outputFields).foldLeft((Object)schema, (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final StructType apply(StructType x0$2, StructField x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$1);
                if (tuple2 != null) {
                    StructType newSchema = (StructType)tuple2._1();
                    StructField outputField = (StructField)tuple2._2();
                    StructType structType = SchemaUtils$.MODULE$.appendColumn(newSchema, outputField);
                    return structType;
                }
                throw new MatchError((Object)tuple2);
            }
        });
    }

    public static void $init$(OneHotEncoderBase $this) {
        $this.org$apache$spark$ml$feature$OneHotEncoderBase$_setter_$handleInvalid_$eq(new Param($this, "handleInvalid", "How to handle invalid data during transform(). Options are 'keep' (invalid data presented as an extra categorical feature) or error (throw an error). Note that this Param is only used during transform; during fitting, invalid data will result in an error.", ParamValidators$.MODULE$.inArray(OneHotEncoderEstimator$.MODULE$.supportedHandleInvalids())));
        $this.setDefault($this.handleInvalid(), OneHotEncoderEstimator$.MODULE$.ERROR_INVALID());
        $this.org$apache$spark$ml$feature$OneHotEncoderBase$_setter_$dropLast_$eq(new BooleanParam($this, "dropLast", "whether to drop the last category"));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.dropLast().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
    }
}

