/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.google.inject.Injector;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.features.ElasticIPAddressApi;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.features.KeyPairApi;
import org.jclouds.ec2.features.SecurityGroupApi;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.ec2.predicates.InstanceHasIpAddress;
import org.jclouds.ec2.predicates.InstanceStateRunning;
import org.jclouds.http.HttpResponseException;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.scriptbuilder.ScriptBuilder;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.SshException;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=false, singleThreaded=true, testName="CloudApplicationArchitecturesEC2ApiLiveTest")
public class CloudApplicationArchitecturesEC2ApiLiveTest
extends BaseComputeServiceContextLiveTest {
    private EC2Api client;
    protected SshClient.Factory sshFactory;
    private String instancePrefix = System.getProperty("user.name") + ".ec2";
    private KeyPair keyPair;
    private String securityGroupName;
    private String instanceId;
    private String address;
    private Predicate<HostAndPort> socketTester;
    private Predicate<RunningInstance> hasIpTester;
    private Predicate<RunningInstance> runningTester;

    public CloudApplicationArchitecturesEC2ApiLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        Injector injector = ((ComputeServiceContext)this.view).utils().injector();
        this.client = (EC2Api)injector.getInstance(EC2Api.class);
        this.sshFactory = (SshClient.Factory)injector.getInstance(SshClient.Factory.class);
        this.runningTester = Predicates2.retry((Predicate)new InstanceStateRunning(this.client), (long)180L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        this.hasIpTester = Predicates2.retry((Predicate)new InstanceHasIpAddress(this.client), (long)180L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        SocketOpen socketOpen = (SocketOpen)injector.getInstance(SocketOpen.class);
        this.socketTester = Predicates2.retry((Predicate)socketOpen, (long)180L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test(enabled=false)
    void testCreateSecurityGroupIngressCidr() throws InterruptedException, ExecutionException, TimeoutException {
        this.securityGroupName = this.instancePrefix + "ingress";
        try {
            ((SecurityGroupApi)this.client.getSecurityGroupApi().get()).deleteSecurityGroupInRegion(null, this.securityGroupName);
        }
        catch (Exception e) {
            // empty catch block
        }
        ((SecurityGroupApi)this.client.getSecurityGroupApi().get()).createSecurityGroupInRegion(null, this.securityGroupName, this.securityGroupName);
        for (int port : new int[]{80, 443, 22}) {
            ((SecurityGroupApi)this.client.getSecurityGroupApi().get()).authorizeSecurityGroupIngressInRegion(null, this.securityGroupName, IpProtocol.TCP, port, port, "0.0.0.0/0");
        }
    }

    @Test(enabled=false)
    void testCreateKeyPair() throws InterruptedException, ExecutionException, TimeoutException {
        String keyName = this.instancePrefix + "1";
        try {
            ((KeyPairApi)this.client.getKeyPairApi().get()).deleteKeyPairInRegion(null, keyName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((KeyPairApi)this.client.getKeyPairApi().get()).deleteKeyPairInRegion(null, keyName);
        this.keyPair = ((KeyPairApi)this.client.getKeyPairApi().get()).createKeyPairInRegion(null, keyName);
        Assert.assertNotNull((Object)this.keyPair);
        Assert.assertNotNull((Object)this.keyPair.getKeyMaterial());
        Assert.assertNotNull((Object)this.keyPair.getSha1OfPrivateKey());
        Assert.assertEquals((String)this.keyPair.getKeyName(), (String)keyName);
    }

    @Test(enabled=false, dependsOnMethods={"testCreateKeyPair", "testCreateSecurityGroupIngressCidr"})
    public void testCreateRunningInstance() throws Exception {
        String script = new ScriptBuilder().addStatement(Statements.exec((String)"runurl run.alestic.com/apt/upgrade")).addStatement(Statements.exec((String)"runurl run.alestic.com/install/lamp")).render(OsFamily.UNIX);
        RunningInstance instance = null;
        while (instance == null) {
            try {
                System.out.printf("%d: running instance%n", System.currentTimeMillis());
                Reservation reservation = ((InstanceApi)this.client.getInstanceApi().get()).runInstancesInRegion(null, null, "ami-ccf615a5", 1, 1, new RunInstancesOptions[]{RunInstancesOptions.Builder.asType((String)"m1.small").withKeyName(this.keyPair.getKeyName()).withSecurityGroup(this.securityGroupName).withUserData(script.getBytes())});
                instance = (RunningInstance)Iterables.getOnlyElement((Iterable)reservation);
            }
            catch (HttpResponseException htpe) {
                if (htpe.getResponse().getStatusCode() == 400) continue;
                throw htpe;
            }
        }
        Assert.assertNotNull((Object)instance.getId());
        this.instanceId = instance.getId();
        Assert.assertEquals((Object)instance.getInstanceState(), (Object)InstanceState.PENDING);
        instance = this.blockUntilWeCanSshIntoInstance(instance);
        this.verifyInstanceProperties(script);
        this.tryToChangeStuff();
        this.sshPing(instance);
        System.out.printf("%d: %s ssh connection made%n", System.currentTimeMillis(), this.instanceId);
    }

    private void verifyInstanceProperties(String script) {
        Assert.assertEquals((String)script, (String)((InstanceApi)this.client.getInstanceApi().get()).getUserDataForInstanceInRegion(null, this.instanceId));
        Assert.assertEquals(null, (String)((InstanceApi)this.client.getInstanceApi().get()).getRootDeviceNameForInstanceInRegion(null, this.instanceId));
        assert (((InstanceApi)this.client.getInstanceApi().get()).getRamdiskForInstanceInRegion(null, this.instanceId).startsWith("ari-"));
        Assert.assertEquals((boolean)false, (boolean)((InstanceApi)this.client.getInstanceApi().get()).isApiTerminationDisabledForInstanceInRegion(null, this.instanceId));
        assert (((InstanceApi)this.client.getInstanceApi().get()).getKernelForInstanceInRegion(null, this.instanceId).startsWith("aki-"));
        Assert.assertEquals((String)"m1.small", (String)((InstanceApi)this.client.getInstanceApi().get()).getInstanceTypeForInstanceInRegion(null, this.instanceId));
        Assert.assertEquals((Object)Volume.InstanceInitiatedShutdownBehavior.TERMINATE, (Object)((InstanceApi)this.client.getInstanceApi().get()).getInstanceInitiatedShutdownBehaviorForInstanceInRegion(null, this.instanceId));
        Assert.assertEquals((Map)ImmutableMap.of(), (Map)((InstanceApi)this.client.getInstanceApi().get()).getBlockDeviceMappingForInstanceInRegion(null, this.instanceId));
    }

    private void setApiTerminationDisabledForInstanceInRegion() {
        ((InstanceApi)this.client.getInstanceApi().get()).setApiTerminationDisabledForInstanceInRegion(null, this.instanceId, true);
        Assert.assertEquals((boolean)true, (boolean)((InstanceApi)this.client.getInstanceApi().get()).isApiTerminationDisabledForInstanceInRegion(null, this.instanceId));
        ((InstanceApi)this.client.getInstanceApi().get()).setApiTerminationDisabledForInstanceInRegion(null, this.instanceId, false);
        Assert.assertEquals((boolean)false, (boolean)((InstanceApi)this.client.getInstanceApi().get()).isApiTerminationDisabledForInstanceInRegion(null, this.instanceId));
    }

    private void tryToChangeStuff() {
        this.setApiTerminationDisabledForInstanceInRegion();
        this.setUserDataForInstanceInRegion();
        this.setRamdiskForInstanceInRegion();
        this.setKernelForInstanceInRegion();
        this.setInstanceTypeForInstanceInRegion();
        this.setInstanceInitiatedShutdownBehaviorForInstanceInRegion();
        this.setBlockDeviceMappingForInstanceInRegion();
    }

    private void setUserDataForInstanceInRegion() {
        try {
            ((InstanceApi)this.client.getInstanceApi().get()).setUserDataForInstanceInRegion(null, this.instanceId, "test".getBytes());
            Assert.fail((String)"shouldn't be allowed, as instance needs to be stopped");
        }
        catch (AWSResponseException e) {
            Assert.assertEquals((String)"IncorrectInstanceState", (String)e.getError().getCode());
        }
    }

    private void setRamdiskForInstanceInRegion() {
        try {
            String ramdisk = ((InstanceApi)this.client.getInstanceApi().get()).getRamdiskForInstanceInRegion(null, this.instanceId);
            ((InstanceApi)this.client.getInstanceApi().get()).setRamdiskForInstanceInRegion(null, this.instanceId, ramdisk);
            Assert.fail((String)"shouldn't be allowed, as instance needs to be stopped");
        }
        catch (AWSResponseException e) {
            Assert.assertEquals((String)"IncorrectInstanceState", (String)e.getError().getCode());
        }
    }

    private void setKernelForInstanceInRegion() {
        try {
            String oldKernel = ((InstanceApi)this.client.getInstanceApi().get()).getKernelForInstanceInRegion(null, this.instanceId);
            ((InstanceApi)this.client.getInstanceApi().get()).setKernelForInstanceInRegion(null, this.instanceId, oldKernel);
            Assert.fail((String)"shouldn't be allowed, as instance needs to be stopped");
        }
        catch (AWSResponseException e) {
            Assert.assertEquals((String)"IncorrectInstanceState", (String)e.getError().getCode());
        }
    }

    private void setInstanceTypeForInstanceInRegion() {
        try {
            ((InstanceApi)this.client.getInstanceApi().get()).setInstanceTypeForInstanceInRegion(null, this.instanceId, "c1.medium");
            Assert.fail((String)"shouldn't be allowed, as instance needs to be stopped");
        }
        catch (AWSResponseException e) {
            Assert.assertEquals((String)"IncorrectInstanceState", (String)e.getError().getCode());
        }
    }

    private void setBlockDeviceMappingForInstanceInRegion() {
        LinkedHashMap mapping = Maps.newLinkedHashMap();
        try {
            ((InstanceApi)this.client.getInstanceApi().get()).setBlockDeviceMappingForInstanceInRegion(null, this.instanceId, (Map)mapping);
            Assert.fail((String)"shouldn't be allowed, as instance needs to be ebs based-ami");
        }
        catch (AWSResponseException e) {
            Assert.assertEquals((String)"InvalidParameterCombination", (String)e.getError().getCode());
        }
    }

    private void setInstanceInitiatedShutdownBehaviorForInstanceInRegion() {
        try {
            ((InstanceApi)this.client.getInstanceApi().get()).setInstanceInitiatedShutdownBehaviorForInstanceInRegion(null, this.instanceId, Volume.InstanceInitiatedShutdownBehavior.STOP);
            Assert.fail((String)"shouldn't be allowed, as instance needs to be ebs based-ami");
        }
        catch (AWSResponseException e) {
            Assert.assertEquals((String)"UnsupportedInstanceAttribute", (String)e.getError().getCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false, dependsOnMethods={"testCreateRunningInstance"})
    void testReboot() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        RunningInstance instance = this.getInstance(this.instanceId);
        System.out.printf("%d: %s rebooting instance %n", System.currentTimeMillis(), this.instanceId);
        ((InstanceApi)this.client.getInstanceApi().get()).rebootInstancesInRegion(null, new String[]{this.instanceId});
        Thread.sleep(1000L);
        instance = this.getInstance(this.instanceId);
        this.blockUntilWeCanSshIntoInstance(instance);
        SshClient ssh = this.sshFactory.create(HostAndPort.fromParts((String)instance.getIpAddress(), (int)22), LoginCredentials.builder().user("root").privateKey(this.keyPair.getKeyMaterial()).build());
        try {
            ssh.connect();
            ExecResponse uptime = ssh.exec("uptime");
            assert (uptime.getOutput().indexOf("0 min") != -1) : "reboot didn't work: " + uptime;
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
    }

    @Test(enabled=false, dependsOnMethods={"testReboot"})
    void testElasticIpAddress() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.address = ((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).allocateAddressInRegion(null);
        Assert.assertNotNull((Object)this.address);
        PublicIpInstanceIdPair compare = (PublicIpInstanceIdPair)Iterables.getLast((Iterable)((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).describeAddressesInRegion(null, new String[]{this.address}));
        Assert.assertEquals((String)compare.getPublicIp(), (String)this.address);
        assert (compare.getInstanceId() == null);
        ((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).associateAddressInRegion(null, this.address, this.instanceId);
        compare = (PublicIpInstanceIdPair)Iterables.getLast((Iterable)((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).describeAddressesInRegion(null, new String[]{this.address}));
        Assert.assertEquals((String)compare.getPublicIp(), (String)this.address);
        Assert.assertEquals((String)compare.getInstanceId(), (String)this.instanceId);
        Reservation reservation = (Reservation)Iterables.getOnlyElement((Iterable)((InstanceApi)this.client.getInstanceApi().get()).describeInstancesInRegion(null, new String[]{this.instanceId}));
        Assert.assertNotNull((Object)((RunningInstance)Iterables.getOnlyElement((Iterable)reservation)).getIpAddress());
        Assert.assertNotEquals((Object)this.address, (Object)((RunningInstance)Iterables.getOnlyElement((Iterable)reservation)).getIpAddress());
        this.doCheckKey(this.address);
        ((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).disassociateAddressInRegion(null, this.address);
        compare = (PublicIpInstanceIdPair)Iterables.getLast((Iterable)((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).describeAddressesInRegion(null, new String[]{this.address}));
        Assert.assertEquals((String)compare.getPublicIp(), (String)this.address);
        assert (compare.getInstanceId() == null);
        reservation = (Reservation)Iterables.getOnlyElement((Iterable)((InstanceApi)this.client.getInstanceApi().get()).describeInstancesInRegion(null, new String[]{this.instanceId}));
    }

    private RunningInstance blockUntilWeCanSshIntoInstance(RunningInstance instance) throws UnknownHostException {
        System.out.printf("%d: %s awaiting instance to run %n", System.currentTimeMillis(), instance.getId());
        assert (this.runningTester.apply((Object)instance));
        instance = this.getInstance(instance.getId());
        System.out.printf("%d: %s awaiting instance to have ip assigned %n", System.currentTimeMillis(), instance.getId());
        assert (this.hasIpTester.apply((Object)instance));
        System.out.printf("%d: %s awaiting ssh service to start%n", System.currentTimeMillis(), instance.getIpAddress());
        assert (this.socketTester.apply((Object)HostAndPort.fromParts((String)instance.getIpAddress(), (int)22)));
        System.out.printf("%d: %s ssh service started%n", System.currentTimeMillis(), instance.getDnsName());
        this.sshPing(instance);
        System.out.printf("%d: %s ssh connection made%n", System.currentTimeMillis(), instance.getId());
        System.out.printf("%d: %s awaiting http service to start%n", System.currentTimeMillis(), instance.getIpAddress());
        assert (this.socketTester.apply((Object)HostAndPort.fromParts((String)instance.getIpAddress(), (int)80)));
        System.out.printf("%d: %s http service started%n", System.currentTimeMillis(), instance.getDnsName());
        return instance;
    }

    private RunningInstance getInstance(String instanceId) {
        Set reservations = ((InstanceApi)this.client.getInstanceApi().get()).describeInstancesInRegion(null, new String[]{instanceId});
        return (RunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)reservations)));
    }

    private void sshPing(RunningInstance newDetails) throws UnknownHostException {
        try {
            this.doCheckKey(newDetails);
        }
        catch (SshException e) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.doCheckKey(newDetails);
        }
    }

    private void doCheckKey(RunningInstance newDetails) throws UnknownHostException {
        this.doCheckKey(newDetails.getIpAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckKey(String address) {
        SshClient ssh = this.sshFactory.create(HostAndPort.fromParts((String)address, (int)22), LoginCredentials.builder().user("root").privateKey(this.keyPair.getKeyMaterial()).build());
        try {
            ssh.connect();
            ExecResponse hello = ssh.exec("echo hello");
            Assert.assertEquals((String)hello.getOutput().trim(), (String)"hello");
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
    }

    @AfterTest
    void cleanup() throws InterruptedException, ExecutionException, TimeoutException {
        if (this.address != null) {
            ((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).releaseAddressInRegion(null, this.address);
        }
        if (this.instanceId != null) {
            ((InstanceApi)this.client.getInstanceApi().get()).terminateInstancesInRegion(null, new String[]{this.instanceId});
        }
        if (this.keyPair != null) {
            ((KeyPairApi)this.client.getKeyPairApi().get()).deleteKeyPairInRegion(null, this.keyPair.getKeyName());
        }
        if (this.securityGroupName != null) {
            ((SecurityGroupApi)this.client.getSecurityGroupApi().get()).deleteSecurityGroupInRegion(null, this.securityGroupName);
        }
    }
}

