/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import org.jclouds.ec2.binders.BindVolumeIdsToIndexedFormParams;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindVolumeIdsToIndexedFormParamsTest {
    Injector injector = Guice.createInjector((Module[])new Module[0]);
    BindVolumeIdsToIndexedFormParams binder = (BindVolumeIdsToIndexedFormParams)this.injector.getInstance(BindVolumeIdsToIndexedFormParams.class);

    public void test() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)new String[]{"alpha", "omega"});
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"VolumeId.1=alpha&VolumeId.2=omega");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeArray() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        this.binder.bindToRequest(request, null);
    }
}

