/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.internal.BaseEC2ComputeServiceExpectTest;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EC2ComputeServiceExpectTest")
public class EC2ComputeServiceExpectTest
extends BaseEC2ComputeServiceExpectTest {
    public void testCreateNodeWithGeneratedKeyPairAndOverriddenLoginUser() throws Exception {
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)this.describeImagesRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.describeSecurityGroupRequest, (Object)this.describeSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.runInstancesRequest, (Object)this.runInstancesResponse);
        requestResponseMap.put((Object)this.describeInstanceRequest, (Object)this.describeInstanceResponse);
        requestResponseMap.put((Object)this.describeInstanceMultiIdsRequest, (Object)this.describeInstanceMultiIdsResponse);
        requestResponseMap.put((Object)this.describeImageRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)this.createTagsRequest, (Object)this.createTagsResponse);
        ComputeService apiThatCreatesNode = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build());
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)apiThatCreatesNode.createNodesInGroup("test", 1, (TemplateOptions)EC2TemplateOptions.Builder.blockUntilRunning((boolean)false).overrideLoginUser("ec2-user")));
        Assert.assertEquals((String)node.getCredentials().getUser(), (String)"ec2-user");
        System.out.println(node.getImageId());
        Assert.assertNotNull((Object)node.getCredentials().getPrivateKey());
    }

    public void testCreateNodeWithSpecifiedName() throws Exception {
        HttpRequest createNamedTagsRequest = this.formSigner.filter(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(EC2ComputeServiceExpectTest.payloadFromStringWithContentType((String)"Action=CreateTags&ResourceId.1=i-2baa5550&Signature=Trp5e5%2BMqeBeBZbLYa9s9gxahQ9nkx6ETfsGl82IV8Y%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Tag.1.Key=Name&Tag.1.Value=test-node&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-08-31&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build());
        HttpResponse describeNamedInstanceResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_instances_running-named.xml", "application/xml"))).build();
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)this.describeImagesRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.describeSecurityGroupRequest, (Object)this.describeSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.runInstancesRequest, (Object)this.runInstancesResponse);
        requestResponseMap.put((Object)this.describeInstanceRequest, (Object)describeNamedInstanceResponse);
        requestResponseMap.put((Object)this.describeInstanceMultiIdsRequest, (Object)this.describeInstanceMultiIdsResponse);
        requestResponseMap.put((Object)this.describeImageRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)createNamedTagsRequest, (Object)this.createTagsResponse);
        ComputeService apiThatCreatesNode = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build());
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)apiThatCreatesNode.createNodesInGroup("test", 1, (TemplateOptions)EC2TemplateOptions.Builder.blockUntilRunning((boolean)false).overrideLoginUser("ec2-user").nodeNames((Iterable)ImmutableSet.of((Object)"test-node"))));
        Assert.assertEquals((String)node.getCredentials().getUser(), (String)"ec2-user");
        Assert.assertNotNull((Object)node.getCredentials().getPrivateKey());
        Assert.assertEquals((String)node.getName(), (String)"test-node");
    }

    @Test(enabled=false)
    public void testCreateNodeWithGeneratedKeyPairAndOverriddenLoginUserWithTemplateBuilder() throws Exception {
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)this.describeImagesRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.describeSecurityGroupRequest, (Object)this.describeSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.runInstancesRequest, (Object)this.runInstancesResponse);
        requestResponseMap.put((Object)this.describeInstanceRequest, (Object)this.describeInstanceResponse);
        requestResponseMap.put((Object)this.describeInstanceMultiIdsRequest, (Object)this.describeInstanceMultiIdsResponse);
        requestResponseMap.put((Object)this.describeImageRequest, (Object)this.describeImagesResponse);
        requestResponseMap.put((Object)this.createTagsRequest, (Object)this.createTagsResponse);
        ComputeService apiThatCreatesNode = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build());
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)apiThatCreatesNode.createNodesInGroup("test", 1, apiThatCreatesNode.templateBuilder().from("osDescriptionMatches=.*fedora.*,loginUser=ec2-user").build()));
        Assert.assertEquals((String)node.getCredentials().getUser(), (String)"ec2-user");
        Assert.assertNotNull((Object)node.getCredentials().getPrivateKey());
    }
}

