/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.extensions;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import java.util.Properties;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.compute.extensions.internal.BaseImageExtensionLiveTest;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="EC2ImageExtensionLiveTest")
public class EC2ImageExtensionLiveTest
extends BaseImageExtensionLiveTest {
    protected TemplateBuilderSpec ebsTemplate;

    public EC2ImageExtensionLiveTest() {
        this.provider = "ec2";
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        String ebsSpec = (String)Preconditions.checkNotNull((Object)this.setIfTestSystemPropertyPresent(overrides, this.provider + ".ebs-template"), (Object)(this.provider + ".ebs-template"));
        this.ebsTemplate = TemplateBuilderSpec.parse((String)ebsSpec);
        return overrides;
    }

    public Template getNodeTemplate() {
        return ((ComputeServiceContext)this.view).getComputeService().templateBuilder().from(this.ebsTemplate).build();
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }
}

