/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.extensions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.internal.BaseEC2ComputeServiceExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EC2SecurityGroupExtensionExpectTest")
public class EC2SecurityGroupExtensionExpectTest
extends BaseEC2ComputeServiceExpectTest {
    public void testListSecurityGroups() {
        HttpRequest describeSecurityGroupsAllRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).build());
        HttpResponse describeSecurityGroupsAllResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_securitygroups_extension_new.xml", "application/xml"))).build();
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)describeSecurityGroupsAllRequest, (Object)describeSecurityGroupsAllResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.describeInstanceRequest, (Object)this.describeInstanceResponse);
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getSecurityGroupExtension().get();
        Set groups = extension.listSecurityGroups();
        Assert.assertEquals((int)2, (int)groups.size());
    }

    public void testListSecurityGroupsInLocation() {
        HttpRequest describeSecurityGroupsAllRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).build());
        HttpResponse describeSecurityGroupsAllResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_securitygroups_extension_new.xml", "application/xml"))).build();
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)describeSecurityGroupsAllRequest, (Object)describeSecurityGroupsAllResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.describeInstanceRequest, (Object)this.describeInstanceResponse);
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getSecurityGroupExtension().get();
        Set groups = extension.listSecurityGroupsInLocation(new LocationBuilder().scope(LocationScope.REGION).id(this.region).description("region").build());
        Assert.assertEquals((int)2, (int)groups.size());
    }

    public void testListSecurityGroupsForNode() {
        HttpRequest describeSecurityGroupsSingleRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).addFormParam("GroupName.1", new String[]{"sg-3c6ef654"}).build());
        HttpResponse describeSecurityGroupsSingleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_securitygroups_extension_single.xml", "application/xml"))).build();
        HttpResponse describeInstanceWithSGResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_instances_running_securitygroups.xml", "application/xml"))).build();
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)describeSecurityGroupsSingleRequest, (Object)describeSecurityGroupsSingleResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.describeInstanceRequest, (Object)describeInstanceWithSGResponse);
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getSecurityGroupExtension().get();
        Set groups = extension.listSecurityGroupsForNode(new RegionAndName(this.region, "i-2baa5550").slashEncode());
        Assert.assertEquals((int)1, (int)groups.size());
    }

    public void testGetSecurityGroupById() {
        HttpRequest describeSecurityGroupsSingleRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).addFormParam("GroupName.1", new String[]{"jclouds#some-group"}).build());
        HttpResponse describeSecurityGroupsSingleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_securitygroups_extension_single.xml", "application/xml"))).build();
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)describeSecurityGroupsSingleRequest, (Object)describeSecurityGroupsSingleResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getSecurityGroupExtension().get();
        SecurityGroup group = extension.getSecurityGroupById(new RegionAndName(this.region, "jclouds#some-group").slashEncode());
        Assert.assertEquals((String)"sg-3c6ef654", (String)group.getProviderId());
        Assert.assertEquals((String)(this.region + "/jclouds#some-group"), (String)group.getId());
    }

    public void testCreateSecurityGroup() {
        HttpRequest createSecurityGroupExtRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"CreateSecurityGroup"}).addFormParam("GroupDescription", new String[]{"jclouds#some-group"}).addFormParam("GroupName", new String[]{"jclouds#some-group"}).build());
        HttpRequest describeSecurityGroupsSingleRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).addFormParam("GroupName.1", new String[]{"jclouds#some-group"}).build());
        HttpResponse describeSecurityGroupsSingleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_securitygroups_extension_single.xml", "application/xml"))).build();
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)describeSecurityGroupsSingleRequest, (Object)describeSecurityGroupsSingleResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)createSecurityGroupExtRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getSecurityGroupExtension().get();
        SecurityGroup group = extension.createSecurityGroup("some-group", new LocationBuilder().scope(LocationScope.REGION).id(this.region).description("region").build());
        Assert.assertEquals((String)"sg-3c6ef654", (String)group.getProviderId());
        Assert.assertEquals((String)(this.region + "/jclouds#some-group"), (String)group.getId());
    }

    public void testRemoveSecurityGroup() {
        HttpRequest describeSecurityGroupsSingleRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).addFormParam("GroupName.1", new String[]{"jclouds#some-group"}).build());
        HttpResponse describeSecurityGroupsSingleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_securitygroups_extension_single.xml", "application/xml"))).build();
        HttpRequest deleteSecurityGroupRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DeleteSecurityGroup"}).addFormParam("GroupName", new String[]{"jclouds#some-group"}).build());
        HttpResponse deleteSecurityGroupResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/delete_securitygroup.xml", "application/xml"))).build();
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)describeSecurityGroupsSingleRequest, (Object)describeSecurityGroupsSingleResponse);
        requestResponseMap.put((Object)deleteSecurityGroupRequest, (Object)deleteSecurityGroupResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequest22, (Object)this.authorizeSecurityGroupIngressResponse);
        requestResponseMap.put((Object)this.authorizeSecurityGroupIngressRequestGroup, (Object)this.authorizeSecurityGroupIngressResponse);
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getSecurityGroupExtension().get();
        Assert.assertTrue((boolean)extension.removeSecurityGroup(new RegionAndName(this.region, "jclouds#some-group").slashEncode()));
    }

    public void testAddIpPermissionCidrFromIpPermission() {
        HttpRequest describeSecurityGroupsSingleRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).addFormParam("GroupName.1", new String[]{"jclouds#some-group"}).build());
        HttpResponse describeSecurityGroupsSingleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_securitygroups_extension_cidr.xml", "application/xml"))).build();
        HttpRequest authorizeSecurityGroupIngressRequestRange = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"AuthorizeSecurityGroupIngress"}).addFormParam("CidrIp", new String[]{"0.0.0.0/0"}).addFormParam("FromPort", new String[]{"22"}).addFormParam("ToPort", new String[]{"40"}).addFormParam("GroupName", new String[]{"jclouds#some-group"}).addFormParam("IpProtocol", new String[]{"tcp"}).build());
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)describeSecurityGroupsSingleRequest, (Object)describeSecurityGroupsSingleResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)authorizeSecurityGroupIngressRequestRange, (Object)this.authorizeSecurityGroupIngressResponse);
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(IpProtocol.TCP);
        builder.fromPort(22);
        builder.toPort(40);
        builder.cidrBlock("0.0.0.0/0");
        IpPermission perm = builder.build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getSecurityGroupExtension().get();
        SecurityGroupBuilder groupBuilder = new SecurityGroupBuilder();
        groupBuilder.id("jclouds#some-group");
        groupBuilder.providerId("sg-3c6ef654");
        groupBuilder.name("jclouds#some-group");
        groupBuilder.location(new LocationBuilder().scope(LocationScope.REGION).id(this.region).description("region").build());
        SecurityGroup origGroup = groupBuilder.build();
        SecurityGroup newGroup = extension.addIpPermission(perm, origGroup);
        Assert.assertEquals((int)1, (int)newGroup.getIpPermissions().size());
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertNotNull((Object)newPerm);
        Assert.assertEquals((Object)IpProtocol.TCP, (Object)newPerm.getIpProtocol());
        Assert.assertEquals((int)22, (int)newPerm.getFromPort());
        Assert.assertEquals((int)40, (int)newPerm.getToPort());
        Assert.assertEquals((int)1, (int)newPerm.getCidrBlocks().size());
        Assert.assertTrue((boolean)newPerm.getCidrBlocks().contains("0.0.0.0/0"));
    }

    public void testAddIpPermissionCidrFromParams() {
        HttpRequest describeSecurityGroupsSingleRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).addFormParam("GroupName.1", new String[]{"jclouds#some-group"}).build());
        HttpResponse describeSecurityGroupsSingleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_securitygroups_extension_cidr.xml", "application/xml"))).build();
        HttpRequest authorizeSecurityGroupIngressRequestRange = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"AuthorizeSecurityGroupIngress"}).addFormParam("CidrIp", new String[]{"0.0.0.0/0"}).addFormParam("FromPort", new String[]{"22"}).addFormParam("ToPort", new String[]{"40"}).addFormParam("GroupName", new String[]{"jclouds#some-group"}).addFormParam("IpProtocol", new String[]{"tcp"}).build());
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)describeSecurityGroupsSingleRequest, (Object)describeSecurityGroupsSingleResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)authorizeSecurityGroupIngressRequestRange, (Object)this.authorizeSecurityGroupIngressResponse);
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getSecurityGroupExtension().get();
        SecurityGroupBuilder groupBuilder = new SecurityGroupBuilder();
        groupBuilder.id("jclouds#some-group");
        groupBuilder.providerId("sg-3c6ef654");
        groupBuilder.name("jclouds#some-group");
        groupBuilder.location(new LocationBuilder().scope(LocationScope.REGION).id(this.region).description("region").build());
        SecurityGroup origGroup = groupBuilder.build();
        SecurityGroup newGroup = extension.addIpPermission(IpProtocol.TCP, 22, 40, this.emptyMultimap(), (Iterable)ImmutableSet.of((Object)"0.0.0.0/0"), this.emptyStringSet(), origGroup);
        Assert.assertEquals((int)1, (int)newGroup.getIpPermissions().size());
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertNotNull((Object)newPerm);
        Assert.assertEquals((Object)IpProtocol.TCP, (Object)newPerm.getIpProtocol());
        Assert.assertEquals((int)22, (int)newPerm.getFromPort());
        Assert.assertEquals((int)40, (int)newPerm.getToPort());
        Assert.assertEquals((int)1, (int)newPerm.getCidrBlocks().size());
        Assert.assertTrue((boolean)newPerm.getCidrBlocks().contains("0.0.0.0/0"));
    }

    public void testAddIpPermissionGroupFromIpPermission() {
        HttpRequest describeSecurityGroupsSingleRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).addFormParam("GroupName.1", new String[]{"jclouds#some-group"}).build());
        HttpResponse describeSecurityGroupsSingleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_securitygroups_extension_group.xml", "application/xml"))).build();
        HttpRequest authorizeSecurityGroupIngressRequestGroupTenant = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"AuthorizeSecurityGroupIngress"}).addFormParam("SourceSecurityGroupName", new String[]{"jclouds#some-group"}).addFormParam("SourceSecurityGroupOwnerId", new String[]{"993194456877"}).addFormParam("GroupName", new String[]{"jclouds#some-group"}).build());
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)describeSecurityGroupsSingleRequest, (Object)describeSecurityGroupsSingleResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)authorizeSecurityGroupIngressRequestGroupTenant, (Object)this.authorizeSecurityGroupIngressResponse);
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(IpProtocol.TCP);
        builder.fromPort(22);
        builder.toPort(40);
        builder.tenantIdGroupNamePair("993194456877", "jclouds#some-group");
        IpPermission perm = builder.build();
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getSecurityGroupExtension().get();
        SecurityGroupBuilder groupBuilder = new SecurityGroupBuilder();
        groupBuilder.id("jclouds#some-group");
        groupBuilder.providerId("sg-3c6ef654");
        groupBuilder.name("jclouds#some-group");
        groupBuilder.location(new LocationBuilder().scope(LocationScope.REGION).id(this.region).description("region").build());
        groupBuilder.ownerId("993194456877");
        SecurityGroup origGroup = groupBuilder.build();
        SecurityGroup newGroup = extension.addIpPermission(perm, origGroup);
        Assert.assertEquals((int)1, (int)newGroup.getIpPermissions().size());
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertNotNull((Object)newPerm);
        Assert.assertEquals((Object)IpProtocol.TCP, (Object)newPerm.getIpProtocol());
        Assert.assertEquals((int)22, (int)newPerm.getFromPort());
        Assert.assertEquals((int)40, (int)newPerm.getToPort());
        Assert.assertEquals((int)0, (int)newPerm.getCidrBlocks().size());
        Assert.assertEquals((int)1, (int)newPerm.getTenantIdGroupNamePairs().size());
        Assert.assertTrue((boolean)newPerm.getTenantIdGroupNamePairs().keySet().contains(origGroup.getOwnerId()));
        Assert.assertTrue((boolean)newPerm.getTenantIdGroupNamePairs().values().contains(origGroup.getName()));
    }

    public void testAddIpPermissionGroupFromParams() {
        HttpRequest describeSecurityGroupsSingleRequest = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).addFormParam("GroupName.1", new String[]{"jclouds#some-group"}).build());
        HttpResponse describeSecurityGroupsSingleResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_securitygroups_extension_group.xml", "application/xml"))).build();
        HttpRequest authorizeSecurityGroupIngressRequestGroupTenant = this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + this.region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + this.region + ".amazonaws.com"})).addFormParam("Action", new String[]{"AuthorizeSecurityGroupIngress"}).addFormParam("SourceSecurityGroupName", new String[]{"jclouds#some-group"}).addFormParam("SourceSecurityGroupOwnerId", new String[]{"993194456877"}).addFormParam("GroupName", new String[]{"jclouds#some-group"}).build());
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        requestResponseMap.put((Object)this.describeAvailabilityZonesRequest, (Object)this.describeAvailabilityZonesResponse);
        requestResponseMap.put((Object)describeSecurityGroupsSingleRequest, (Object)describeSecurityGroupsSingleResponse);
        requestResponseMap.put((Object)this.createKeyPairRequest, (Object)this.createKeyPairResponse);
        requestResponseMap.put((Object)this.createSecurityGroupRequest, (Object)this.createSecurityGroupResponse);
        requestResponseMap.put((Object)authorizeSecurityGroupIngressRequestGroupTenant, (Object)this.authorizeSecurityGroupIngressResponse);
        SecurityGroupExtension extension = (SecurityGroupExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getSecurityGroupExtension().get();
        SecurityGroupBuilder groupBuilder = new SecurityGroupBuilder();
        groupBuilder.id("jclouds#some-group");
        groupBuilder.providerId("sg-3c6ef654");
        groupBuilder.name("jclouds#some-group");
        groupBuilder.ownerId("993194456877");
        groupBuilder.location(new LocationBuilder().scope(LocationScope.REGION).id(this.region).description("region").build());
        SecurityGroup origGroup = groupBuilder.build();
        ImmutableMultimap.Builder permBuilder = ImmutableMultimap.builder();
        permBuilder.put((Object)origGroup.getOwnerId(), (Object)origGroup.getName());
        SecurityGroup newGroup = extension.addIpPermission(IpProtocol.TCP, 22, 40, (Multimap)permBuilder.build(), this.emptyStringSet(), this.emptyStringSet(), origGroup);
        Assert.assertEquals((int)1, (int)newGroup.getIpPermissions().size());
        IpPermission newPerm = (IpPermission)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions());
        Assert.assertNotNull((Object)newPerm);
        Assert.assertEquals((Object)IpProtocol.TCP, (Object)newPerm.getIpProtocol());
        Assert.assertEquals((int)22, (int)newPerm.getFromPort());
        Assert.assertEquals((int)40, (int)newPerm.getToPort());
        Assert.assertEquals((int)0, (int)newPerm.getCidrBlocks().size());
        Assert.assertEquals((int)1, (int)newPerm.getTenantIdGroupNamePairs().size());
        Assert.assertTrue((boolean)newPerm.getTenantIdGroupNamePairs().keySet().contains(origGroup.getOwnerId()));
        Assert.assertTrue((boolean)newPerm.getTenantIdGroupNamePairs().values().contains(origGroup.getName()));
    }

    private Multimap<String, String> emptyMultimap() {
        return LinkedHashMultimap.create();
    }

    private Set<String> emptyStringSet() {
        return Sets.newLinkedHashSet();
    }
}

