/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.AddElasticIpsToNodemetadata;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="AddElasticIpsToNodemetadataTest")
public class AddElasticIpsToNodemetadataTest {
    NodeMetadata node = new NodeMetadataBuilder().status(NodeMetadata.Status.RUNNING).group("zkclustertest").name("foo").hostname("ip-10-212-81-7").privateAddresses((Iterable)ImmutableSet.of((Object)"10.212.81.7")).publicAddresses((Iterable)ImmutableSet.of((Object)"174.129.173.155")).imageId("us-east-1/ami-63be790a").id("us-east-1/i-911444f0").providerId("i-911444f0").tags((Iterable)ImmutableSet.of((Object)"Empty")).userMetadata((Map)ImmutableMap.of((Object)"Name", (Object)"foo")).build();

    @Test
    public void testReturnsNodeWithElasticIpWhenFoundInCacheAndNodeHadAPublicIp() throws Exception {
        RegionAndName key = new RegionAndName("us-east-1", this.node.getProviderId());
        String val = "1.1.1.1";
        LoadingCache<RegionAndName, String> cache = this.cacheOf(key, val);
        AddElasticIpsToNodemetadata fn = new AddElasticIpsToNodemetadata(cache);
        Assert.assertEquals((Set)fn.apply(this.node).getPublicAddresses(), (Set)ImmutableSet.of((Object)"1.1.1.1"));
    }

    @Test
    public void testReturnsNodeWithIpWhenFoundInCacheAndNodeHadNoPublicIp() throws Exception {
        RegionAndName key = new RegionAndName("us-east-1", this.node.getProviderId());
        String val = "1.1.1.1";
        LoadingCache<RegionAndName, String> cache = this.cacheOf(key, val);
        AddElasticIpsToNodemetadata fn = new AddElasticIpsToNodemetadata(cache);
        Assert.assertEquals((Set)fn.apply(NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)this.node).publicAddresses((Iterable)ImmutableSet.of()).build()).getPublicAddresses(), (Set)ImmutableSet.of((Object)"1.1.1.1"));
    }

    @Test
    public void testReturnsSameNodeWhenNotFoundInCache() throws Exception {
        RegionAndName key = new RegionAndName("us-east-1", this.node.getProviderId());
        String val = null;
        LoadingCache<RegionAndName, String> cache = this.cacheOf(key, val);
        AddElasticIpsToNodemetadata fn = new AddElasticIpsToNodemetadata(cache);
        Assert.assertEquals((Set)fn.apply(this.node).getPublicAddresses(), (Set)ImmutableSet.of((Object)"174.129.173.155"));
    }

    private LoadingCache<RegionAndName, String> cacheOf(final RegionAndName key, final String val) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<RegionAndName, String>(){

            public String load(RegionAndName in) throws Exception {
                return key.equals((Object)in) ? val : null;
            }
        });
    }
}

