/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.net.UnknownHostException;
import java.util.Properties;
import org.easymock.EasyMock;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.compute.functions.CreateUniqueKeyPair;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.features.KeyPairApi;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CreateUniqueKeyPairTest")
public class CreateUniqueKeyPairTest {
    @Test
    public void testApply() throws UnknownHostException {
        final EC2Api client = (EC2Api)EasyMock.createMock(EC2Api.class);
        KeyPairApi keyClient = (KeyPairApi)EasyMock.createMock(KeyPairApi.class);
        KeyPair pair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)client.getKeyPairApi()).andReturn((Object)Optional.of((Object)keyClient)).atLeastOnce();
        EasyMock.expect((Object)keyClient.createKeyPairInRegion("region", "jclouds#group#1")).andReturn((Object)pair);
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{keyClient});
        CreateUniqueKeyPair parser = (CreateUniqueKeyPair)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)new EC2ApiMetadata().getDefaultProperties());
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)Suppliers.ofInstance((Object)"1"));
                this.bind(EC2Api.class).toInstance((Object)client);
            }
        }}).getInstance(CreateUniqueKeyPair.class);
        Assert.assertEquals((Object)parser.createNewKeyPairInRegion("region", "group"), (Object)pair);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{keyClient});
    }

    @Test
    public void testApplyWithIllegalStateException() throws UnknownHostException {
        final EC2Api client = (EC2Api)EasyMock.createMock(EC2Api.class);
        KeyPairApi keyClient = (KeyPairApi)EasyMock.createMock(KeyPairApi.class);
        final Supplier uniqueIdSupplier = (Supplier)EasyMock.createMock(Supplier.class);
        KeyPair pair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)client.getKeyPairApi()).andReturn((Object)Optional.of((Object)keyClient)).atLeastOnce();
        EasyMock.expect((Object)uniqueIdSupplier.get()).andReturn((Object)"1");
        EasyMock.expect((Object)keyClient.createKeyPairInRegion("region", "jclouds#group#1")).andThrow((Throwable)new IllegalStateException());
        EasyMock.expect((Object)uniqueIdSupplier.get()).andReturn((Object)"2");
        EasyMock.expect((Object)keyClient.createKeyPairInRegion("region", "jclouds#group#2")).andReturn((Object)pair);
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{keyClient});
        EasyMock.replay((Object[])new Object[]{uniqueIdSupplier});
        CreateUniqueKeyPair parser = (CreateUniqueKeyPair)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)new EC2ApiMetadata().getDefaultProperties());
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)uniqueIdSupplier);
                this.bind(EC2Api.class).toInstance((Object)client);
            }
        }}).getInstance(CreateUniqueKeyPair.class);
        Assert.assertEquals((Object)parser.createNewKeyPairInRegion("region", "group"), (Object)pair);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{keyClient});
        EasyMock.verify((Object[])new Object[]{uniqueIdSupplier});
    }
}

