/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.ec2.compute.functions.EC2SecurityGroupToSecurityGroup;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.util.IpPermissions;
import org.jclouds.net.domain.IpPermission;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EC2SecurityGroupToSecurityGroupTest")
public class EC2SecurityGroupToSecurityGroupTest {
    static Location provider = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").build();

    @Test
    public void testApply() {
        IpPermissions.ToSourceSelection authorization = IpPermissions.permitAnyProtocol();
        SecurityGroup origGroup = SecurityGroup.builder().region("us-east-1").id("some-id").name("some-group").ownerId("some-owner").description("some-description").ipPermission((IpPermission)authorization).build();
        EC2SecurityGroupToSecurityGroup parser = this.createGroupParser((ImmutableSet<Location>)ImmutableSet.of((Object)provider));
        org.jclouds.compute.domain.SecurityGroup group = parser.apply(origGroup);
        Assert.assertEquals((Object)group.getLocation(), (Object)provider);
        Assert.assertEquals((String)group.getId(), (String)(provider.getId() + "/" + origGroup.getName()));
        Assert.assertEquals((String)group.getProviderId(), (String)origGroup.getId());
        Assert.assertEquals((String)group.getName(), (String)origGroup.getName());
        Assert.assertEquals((Set)group.getIpPermissions(), (Set)origGroup);
        Assert.assertEquals((String)group.getOwnerId(), (String)origGroup.getOwnerId());
    }

    private EC2SecurityGroupToSecurityGroup createGroupParser(final ImmutableSet<Location> locations) {
        Supplier<Set<? extends Location>> locationSupplier = new Supplier<Set<? extends Location>>(){

            public Set<? extends Location> get() {
                return locations;
            }
        };
        EC2SecurityGroupToSecurityGroup parser = new EC2SecurityGroupToSecurityGroup((Supplier)locationSupplier);
        return parser;
    }
}

