/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.easymock.EasyMock;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.PresentInstances;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.features.InstanceApi;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class PresentInstancesTest {
    RunningInstance instance1 = (RunningInstance)EasyMock.createMock(RunningInstance.class);
    RunningInstance instance2 = (RunningInstance)EasyMock.createMock(RunningInstance.class);

    @Test
    public void testWhenInstancesPresentSingleCall() {
        EC2Api client = (EC2Api)EasyMock.createMock(EC2Api.class);
        InstanceApi instanceClient = (InstanceApi)EasyMock.createMock(InstanceApi.class);
        EasyMock.expect((Object)client.getInstanceApi()).andReturn((Object)Optional.of((Object)instanceClient));
        EasyMock.expect((Object)instanceClient.describeInstancesInRegion("us-east-1", new String[]{"i-aaaa", "i-bbbb"})).andReturn(Set.class.cast(ImmutableSet.of((Object)Reservation.builder().region("us-east-1").instances((Set)ImmutableSet.of((Object)this.instance1, (Object)this.instance2)).build())));
        EasyMock.replay((Object[])new Object[]{client, instanceClient});
        PresentInstances fn = new PresentInstances(client);
        Assert.assertEquals((Set)fn.apply((Set)ImmutableSet.of((Object)new RegionAndName("us-east-1", "i-aaaa"), (Object)new RegionAndName("us-east-1", "i-bbbb"))), (Set)ImmutableSet.of((Object)this.instance1, (Object)this.instance2));
        EasyMock.verify((Object[])new Object[]{client, instanceClient});
    }
}

