/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.loaders;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.easymock.EasyMock;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.compute.loaders.CreateSecurityGroupIfNeeded;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.domain.UserIdGroupPair;
import org.jclouds.ec2.features.SecurityGroupApi;
import org.jclouds.net.domain.IpProtocol;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="CreateSecurityGroupIfNeeded")
public class CreateSecurityGroupIfNeededTest {
    @Test
    public void testWhenPort22AndToItselfAuthorizesIngressTwice() throws ExecutionException {
        SecurityGroupApi client = (SecurityGroupApi)EasyMock.createMock(SecurityGroupApi.class);
        Predicate tester = Predicates.alwaysTrue();
        SecurityGroup group = (SecurityGroup)EasyMock.createNiceMock(SecurityGroup.class);
        ImmutableSet groups = ImmutableSet.of((Object)group);
        client.createSecurityGroupInRegion("region", "group", "group");
        client.authorizeSecurityGroupIngressInRegion("region", "group", IpProtocol.TCP, 22, 22, "0.0.0.0/0");
        EasyMock.expect((Object)client.describeSecurityGroupsInRegion("region", new String[]{"group"})).andReturn(Set.class.cast(groups));
        EasyMock.expect((Object)group.getOwnerId()).andReturn((Object)"ownerId");
        client.authorizeSecurityGroupIngressInRegion("region", "group", new UserIdGroupPair("ownerId", "group"));
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{group});
        CreateSecurityGroupIfNeeded function = new CreateSecurityGroupIfNeeded(client, tester);
        Assert.assertEquals((String)"group", (String)function.load((RegionAndName)new RegionNameAndIngressRules("region", "group", new int[]{22}, true)));
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{group});
    }

    @Test
    public void testIllegalStateExceptionCreatingGroupJustReturns() throws ExecutionException {
        SecurityGroupApi client = (SecurityGroupApi)EasyMock.createMock(SecurityGroupApi.class);
        Predicate tester = Predicates.alwaysTrue();
        client.createSecurityGroupInRegion("region", "group", "group");
        EasyMock.expectLastCall().andThrow((Throwable)new IllegalStateException());
        EasyMock.replay((Object[])new Object[]{client});
        CreateSecurityGroupIfNeeded function = new CreateSecurityGroupIfNeeded(client, tester);
        Assert.assertEquals((String)"group", (String)function.load((RegionAndName)new RegionNameAndIngressRules("region", "group", new int[]{22}, true)));
        EasyMock.verify((Object[])new Object[]{client});
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testWhenEventualConsistencyExpiresIllegalStateException() throws ExecutionException {
        SecurityGroupApi client = (SecurityGroupApi)EasyMock.createMock(SecurityGroupApi.class);
        Predicate tester = Predicates.alwaysFalse();
        client.createSecurityGroupInRegion("region", "group", "group");
        EasyMock.replay((Object[])new Object[]{client});
        CreateSecurityGroupIfNeeded function = new CreateSecurityGroupIfNeeded(client, tester);
        function.load((RegionAndName)new RegionNameAndIngressRules("region", "group", new int[]{22}, true));
    }
}

