/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.loaders;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import org.easymock.EasyMock;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.loaders.LoadPublicIpForInstanceOrNull;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.features.ElasticIPAddressApi;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="LoadPublicIpForInstanceOrNullTest")
public class LoadPublicIpForInstanceOrNullTest {
    @Test
    public void testReturnsPublicIpOnMatch() throws Exception {
        EC2Api client = (EC2Api)EasyMock.createMock(EC2Api.class);
        ElasticIPAddressApi ipClient = (ElasticIPAddressApi)EasyMock.createMock(ElasticIPAddressApi.class);
        EasyMock.expect((Object)client.getElasticIPAddressApi()).andReturn((Object)Optional.of((Object)ipClient)).atLeastOnce();
        EasyMock.expect((Object)ipClient.describeAddressesInRegion("region", new String[0])).andReturn((Object)ImmutableSet.of((Object)new PublicIpInstanceIdPair("region", "1.1.1.1", "i-blah"))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{ipClient});
        LoadPublicIpForInstanceOrNull parser = new LoadPublicIpForInstanceOrNull(client);
        Assert.assertEquals((String)parser.load(new RegionAndName("region", "i-blah")), (String)"1.1.1.1");
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{ipClient});
    }

    @Test
    public void testReturnsNullWhenNotFound() throws Exception {
        EC2Api client = (EC2Api)EasyMock.createMock(EC2Api.class);
        ElasticIPAddressApi ipClient = (ElasticIPAddressApi)EasyMock.createMock(ElasticIPAddressApi.class);
        EasyMock.expect((Object)client.getElasticIPAddressApi()).andReturn((Object)Optional.of((Object)ipClient)).atLeastOnce();
        EasyMock.expect((Object)ipClient.describeAddressesInRegion("region", new String[0])).andReturn((Object)ImmutableSet.of()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{ipClient});
        LoadPublicIpForInstanceOrNull parser = new LoadPublicIpForInstanceOrNull(client);
        Assert.assertEquals((String)parser.load(new RegionAndName("region", "i-blah")), null);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{ipClient});
    }

    @Test
    public void testReturnsNullWhenNotAssigned() throws Exception {
        EC2Api client = (EC2Api)EasyMock.createMock(EC2Api.class);
        ElasticIPAddressApi ipClient = (ElasticIPAddressApi)EasyMock.createMock(ElasticIPAddressApi.class);
        EasyMock.expect((Object)client.getElasticIPAddressApi()).andReturn((Object)Optional.of((Object)ipClient)).atLeastOnce();
        EasyMock.expect((Object)ipClient.describeAddressesInRegion("region", new String[0])).andReturn((Object)ImmutableSet.of((Object)new PublicIpInstanceIdPair("region", "1.1.1.1", null))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{ipClient});
        LoadPublicIpForInstanceOrNull parser = new LoadPublicIpForInstanceOrNull(client);
        Assert.assertEquals((String)parser.load(new RegionAndName("region", "i-blah")), null);
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{ipClient});
    }
}

