/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.options;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EC2TemplateOptionsTest {
    public void testAs() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        Assert.assertEquals((Object)options.as(EC2TemplateOptions.class), (Object)options);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="all security groups must be non-empty")
    public void testsecurityGroupsIterableBadFormat() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.securityGroups((Iterable)ImmutableSet.of((Object)"group1", (Object)""));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testsecurityGroupsIterableEmptyNotOk() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.securityGroups((Iterable)ImmutableSet.of());
    }

    @Test
    public void testsecurityGroupsIterable() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.securityGroups((Iterable)ImmutableSet.of((Object)"group1", (Object)"group2"));
        Assert.assertEquals((Set)options.getGroups(), (Set)ImmutableSet.of((Object)"group1", (Object)"group2"));
    }

    @Test
    public void testsecurityGroupsIterableStatic() {
        EC2TemplateOptions options = EC2TemplateOptions.Builder.securityGroups((Iterable)ImmutableSet.of((Object)"group1", (Object)"group2"));
        Assert.assertEquals((Set)options.getGroups(), (Set)ImmutableSet.of((Object)"group1", (Object)"group2"));
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="all security groups must be non-empty")
    public void testsecurityGroupsVarArgsBadFormat() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.securityGroups(new String[]{"mygroup", ""});
    }

    @Test
    public void testsecurityGroupsVarArgs() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.securityGroups(new String[]{"group1", "group2"});
        Assert.assertEquals((Set)options.getGroups(), (Set)ImmutableSet.of((Object)"group1", (Object)"group2"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testsecurityGroupsVarArgsEmptyNotOk() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.securityGroups(new String[0]);
    }

    @Test
    public void testDefaultGroupsVarArgsEmpty() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        Assert.assertEquals((Set)options.getGroups(), (Set)ImmutableSet.of());
    }

    @Test
    public void testsecurityGroupsVarArgsStatic() {
        EC2TemplateOptions options = EC2TemplateOptions.Builder.securityGroups((String[])new String[]{"group1", "group2"});
        Assert.assertEquals((Set)options.getGroups(), (Set)ImmutableSet.of((Object)"group1", (Object)"group2"));
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="use noKeyPair option to request boot without a keypair")
    public void testkeyPairBadFormat() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.keyPair("");
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testkeyPairAndNoKeyPair() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.keyPair("mykeypair");
        options.noKeyPair();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testNoKeyPairAndKeyPair() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.noKeyPair();
        options.keyPair("mykeypair");
    }

    @Test
    public void testkeyPair() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.keyPair("mykeypair");
        Assert.assertEquals((String)options.getKeyPair(), (String)"mykeypair");
    }

    @Test
    public void testNullkeyPair() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        Assert.assertEquals((String)options.getKeyPair(), null);
    }

    @Test
    public void testkeyPairStatic() {
        EC2TemplateOptions options = EC2TemplateOptions.Builder.keyPair((String)"mykeypair");
        Assert.assertEquals((String)options.getKeyPair(), (String)"mykeypair");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testkeyPairNPE() {
        EC2TemplateOptions.Builder.keyPair(null);
    }

    @Test
    public void testnoKeyPair() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.noKeyPair();
        Assert.assertEquals((String)options.getKeyPair(), null);
        assert (!options.shouldAutomaticallyCreateKeyPair());
    }

    @Test
    public void testFalsenoKeyPair() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        Assert.assertEquals((String)options.getKeyPair(), null);
        assert (options.shouldAutomaticallyCreateKeyPair());
    }

    @Test
    public void testnoKeyPairStatic() {
        EC2TemplateOptions options = EC2TemplateOptions.Builder.noKeyPair();
        Assert.assertEquals((String)options.getKeyPair(), null);
        assert (!options.shouldAutomaticallyCreateKeyPair());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testinstallPrivateKeyBadFormat() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.installPrivateKey("whompy");
    }

    @Test
    public void testinstallPrivateKey() throws IOException {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.installPrivateKey("-----BEGIN RSA PRIVATE KEY-----");
        Assert.assertEquals((String)options.getPrivateKey(), (String)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Test
    public void testNullinstallPrivateKey() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        Assert.assertEquals((String)options.getPrivateKey(), null);
    }

    @Test
    public void testinstallPrivateKeyStatic() throws IOException {
        EC2TemplateOptions options = EC2TemplateOptions.Builder.installPrivateKey((String)"-----BEGIN RSA PRIVATE KEY-----");
        Assert.assertEquals((String)options.getPrivateKey(), (String)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testinstallPrivateKeyNPE() {
        EC2TemplateOptions.Builder.installPrivateKey(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testauthorizePublicKeyBadFormat() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.authorizePublicKey("whompy");
    }

    @Test
    public void testauthorizePublicKey() throws IOException {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.authorizePublicKey("ssh-rsa");
        Assert.assertEquals((String)options.getPublicKey(), (String)"ssh-rsa");
    }

    @Test
    public void testNullauthorizePublicKey() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        Assert.assertEquals((String)options.getPublicKey(), null);
    }

    @Test
    public void testauthorizePublicKeyStatic() throws IOException {
        EC2TemplateOptions options = EC2TemplateOptions.Builder.authorizePublicKey((String)"ssh-rsa");
        Assert.assertEquals((String)options.getPublicKey(), (String)"ssh-rsa");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testauthorizePublicKeyNPE() {
        EC2TemplateOptions.Builder.authorizePublicKey(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testblockOnPortBadFormat() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.blockOnPort(-1, -1);
    }

    @Test
    public void testblockOnPort() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.blockOnPort(22, 30);
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test
    public void testNullblockOnPort() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        Assert.assertEquals((int)options.getPort(), (int)-1);
        Assert.assertEquals((int)options.getSeconds(), (int)-1);
    }

    @Test
    public void testblockOnPortStatic() {
        EC2TemplateOptions options = EC2TemplateOptions.Builder.blockOnPort((int)22, (int)30);
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testinboundPortsBadFormat() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.inboundPorts(new int[]{-1, -1});
    }

    @Test
    public void testinboundPorts() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        options.inboundPorts(new int[]{22, 30});
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }

    @Test
    public void testDefaultOpen22() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
    }

    @Test
    public void testinboundPortsStatic() {
        EC2TemplateOptions options = EC2TemplateOptions.Builder.inboundPorts((int[])new int[]{22, 30});
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }
}

