/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.inject.Provider;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.domain.EC2HardwareBuilder;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.scriptbuilder.domain.Statements;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptionsTest")
public class CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptionsTest {
    public static final LoginCredentials CREDENTIALS = LoginCredentials.builder().privateKey("-----BEGIN RSA PRIVATE KEY-----\nMIIEowIBAAKCAQEA0CbFlhSdbMdad2ux2BVqk6Ut5fLKb0CdbqubGcEBfwsSz9Rp4Ile76P90MpV\nW1BGKL5V4MO+flG6dZnRWPVmgrNVyDTmEsALiMGjfEwbACEZ1A8C6mPa36wWO7MlxuyMjg8OczTB\nEXnHNDpxE5a6KowJtzFlmgjHk2Y+Q42UIqPx47lQUv5bdMDCnfNNomSzTVRjOZLUkDja+ybCKdux\ngqTsuInhuBRMx+wxff8Z43ECdJV6UPoXK3der1dlZunxGCFkCeYq0kCX7FZ7PV35X744jqhD8P+7\ny5prO4W+M3DWgChUx0OlbDbSHtDVlcfdbj/+4AKYKU6rQOqh+4DPDQIDAQABAoIBAHjQuEiXKJSV\n1U2RZcVtENInws9AL/2I/Jfa5Qh6vTqXG9EjklywfzkK72x7tDVvD3ngmAoAs5WwLFDL+fXvYhOk\nsbql8ZCahVdYRWME7XsSu2IZYHDZipXe1XzLS7b9X8uos5Ns4E8bZuNKtI1RJDdD1vPMqRNR2z0T\n0Dn3eC7t+t+t7PWaK5AXu2ot7DoOeG1QhqJbwd5pMkIn2ydBILytgmDk/2P3EtJGePIJIeQBicmw\nZ0KrJFa/K2cC8AtmMJUoZMo+mh1yemDbDLCZW30PjFHbZtcszS2cydAgq/HDFkZynvZG0zhbx/To\njzcNza1AyypYwOwb2/9/ulXZp0UCgYEA+QFgWDfYLH2zwjU5b6e0UbIyd/X/yRZ+L8lOEBd0Bbu8\nqO3txaDbwi7o2mG7pJENHJ3u62CHjgTGDNW9V9Q8eNoGtj3uHvMvi7FdDEK8B6izdZyR7hmZmQ/5\nMIldelyiGZlz1KBSoy4FsCpA7hV7cI6H6x+Im24NxG90/wd/EgMCgYEA1f+cUyUisIO3yKOCf0hQ\naL289q2//F2cbvBxtki6I8JzTg1H3oTO2WVrXQeCA3a/yiuRUatgGH4mxrpCF6byVJyqrEWAj4kU\nuTbhMgIYhLGoaF1e+vMirCRXUXox0i5X976ASzHn64V9JSd1B+UbKfpcFTYYnChmrRDzmhKN1a8C\ngYBTvIHAyO7ab18/BRUOllAOVSWhr8lXv0eqHEEzKh/rOaoFCRY3qpOcZpgJsGogumK1Z+sLnoeX\nW8WaVVp6KbY4UeGF8aedItyvVnLbB6ohzTqkZ4Wvk05S6cs75kXYO0SL5U3NiCiiFXz2NA9nwTOk\ns1nD2PPgiQ76Kx0mEkhKLwKBgFhHEJqv+AZu37Kx2NRe5WS/2KK9/DPD/hM5tv7mM3sq7Nvm2J3v\nlVDS6J5AyZ5aLzXcER9qncKcz6wtC7SsFs1Wr4VPSoBroRPikrVJbgnXK8yZr+O/xq7Scv7WdJTq\nrzkw6cWbObvLnltkUn/GQBVqBPBvF2nbtLdyBbuqKb5bAoGBAI1+aoJnvXEXxT4UHrMkQcY0eXRz\n3UdbzJmtjMW9CR6l9s11mV6PcZP4qnODp3nd6a+lPeL3wVYQ47DsTJ/Bx5dI17zA5mU57n6mV0a3\nDbSoPKSdaKTQdo2THnVE9P9sPKZWueAcsE4Yw/qcTjoxrtUnAH/AXN250v0tkKIOvMhu\n-----END RSA PRIVATE KEY-----").build();
    public static final KeyPair KEYPAIR = KeyPair.builder().region("ap-southeast-1").keyName("myKeyPair").sha1OfPrivateKey("13:36:74:b9:56:bb:07:96:c0:19:ab:00:7f:9f:06:d2:16:a0:45:32").fingerprint("60:15:d1:f1:d9:e2:3c:e2:ee:a9:64:6a:42:a7:34:0c").keyMaterial(CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptionsTest.CREDENTIALS.credential).build();
    private static final Provider<RunInstancesOptions> OPTIONS_PROVIDER = new Provider<RunInstancesOptions>(){

        public RunInstancesOptions get() {
            return new RunInstancesOptions();
        }
    };

    public void testExecuteWithDefaultOptionsEC2() throws SecurityException, NoSuchMethodException {
        String region = "ap-southeast-1";
        String group = "group";
        Hardware size = EC2HardwareBuilder.m1_small().build();
        String systemGeneratedKeyPairName = "systemGeneratedKeyPair";
        String generatedGroup = "group";
        ImmutableSet generatedGroups = ImmutableSet.of((Object)generatedGroup);
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = (CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions)EasyMock.createMock(CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class, (Method[])new Method[]{CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getOptionsProvider", new Class[0]), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewKeyPairUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getSecurityGroupsForTagAndOptions", String.class, String.class, TemplateOptions.class)});
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)strategy.getOptionsProvider()).andReturn(OPTIONS_PROVIDER);
        EasyMock.expect((Object)template.getHardware()).andReturn((Object)size).atLeastOnce();
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)options).atLeastOnce();
        EasyMock.expect((Object)options.getBlockDeviceMappings()).andReturn((Object)ImmutableSet.of()).atLeastOnce();
        EasyMock.expect((Object)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options)).andReturn((Object)systemGeneratedKeyPairName);
        EasyMock.expect((Object)strategy.getSecurityGroupsForTagAndOptions(region, group, (TemplateOptions)options)).andReturn((Object)generatedGroups);
        EasyMock.expect((Object)options.getUserData()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{template});
        EasyMock.replay((Object[])new Object[]{strategy});
        RunInstancesOptions customize = strategy.execute(region, group, template);
        Assert.assertEquals((Object)customize.buildQueryParameters(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((Collection)customize.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"InstanceType", (Object)size.getProviderId(), (Object)"SecurityGroup.1", (Object)generatedGroup, (Object)"KeyName", (Object)systemGeneratedKeyPairName).entries());
        Assert.assertEquals((Object)customize.buildRequestHeaders(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((String)customize.buildStringPayload(), null);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{strategy});
    }

    public void testExecuteWithUserData() throws SecurityException, NoSuchMethodException {
        String region = "ap-southeast-1";
        String group = "group";
        Hardware size = EC2HardwareBuilder.m1_small().build();
        String systemGeneratedKeyPairName = "systemGeneratedKeyPair";
        String generatedGroup = "group";
        ImmutableSet generatedGroups = ImmutableSet.of((Object)generatedGroup);
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = (CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions)EasyMock.createMock(CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class, (Method[])new Method[]{CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getOptionsProvider", new Class[0]), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("createNewKeyPairUnlessUserSpecifiedOtherwise", String.class, String.class, TemplateOptions.class), CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class.getDeclaredMethod("getSecurityGroupsForTagAndOptions", String.class, String.class, TemplateOptions.class)});
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)strategy.getOptionsProvider()).andReturn(OPTIONS_PROVIDER);
        EasyMock.expect((Object)template.getHardware()).andReturn((Object)size).atLeastOnce();
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)options).atLeastOnce();
        EasyMock.expect((Object)options.getBlockDeviceMappings()).andReturn((Object)ImmutableSet.of()).atLeastOnce();
        EasyMock.expect((Object)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options)).andReturn((Object)systemGeneratedKeyPairName);
        EasyMock.expect((Object)strategy.getSecurityGroupsForTagAndOptions(region, group, (TemplateOptions)options)).andReturn((Object)generatedGroups);
        EasyMock.expect((Object)options.getUserData()).andReturn((Object)"hello".getBytes());
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{template});
        EasyMock.replay((Object[])new Object[]{strategy});
        RunInstancesOptions customize = strategy.execute(region, group, template);
        Assert.assertEquals((Object)customize.buildQueryParameters(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((Collection)customize.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"InstanceType", (Object)size.getProviderId(), (Object)"SecurityGroup.1", (Object)"group", (Object)"KeyName", (Object)systemGeneratedKeyPairName, (Object)"UserData", (Object)BaseEncoding.base64().encode("hello".getBytes())).entries());
        Assert.assertEquals((Object)customize.buildRequestHeaders(), (Object)ImmutableMultimap.of());
        Assert.assertEquals((String)customize.buildStringPayload(), null);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{strategy});
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_reusesKeyWhenToldTo() {
        String region = "ap-southeast-1";
        String group = "group";
        String userSuppliedKeyPair = "myKeyPair";
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getKeyPair()).andReturn((Object)userSuppliedKeyPair);
        EasyMock.expect((Object)options.getLoginPrivateKey()).andReturn(null);
        EasyMock.expect((Object)options.getRunScript()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)userSuppliedKeyPair);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_reusesKeyWhenToldToWithRunScriptButNoCredentials() {
        String region = "ap-southeast-1";
        String group = "group";
        String userSuppliedKeyPair = "myKeyPair";
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getKeyPair()).andReturn((Object)userSuppliedKeyPair);
        EasyMock.expect((Object)options.getLoginUser()).andReturn(null);
        EasyMock.expect((Object)options.getLoginPassword()).andReturn(null);
        EasyMock.expect((Object)options.getLoginPrivateKey()).andReturn(null);
        EasyMock.expect((Object)options.shouldAuthenticateSudo()).andReturn(null);
        EasyMock.expect((Object)options.getRunScript()).andReturn((Object)Statements.exec((String)"echo foo"));
        EasyMock.expect((Object)strategy.credentialsMap.containsKey(new RegionAndName(region, userSuppliedKeyPair))).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)userSuppliedKeyPair);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_reusesKeyWhenToldToWithRunScriptAndCredentialsAlreadyInMap() {
        String region = "ap-southeast-1";
        String group = "group";
        String userSuppliedKeyPair = "myKeyPair";
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getKeyPair()).andReturn((Object)userSuppliedKeyPair);
        EasyMock.expect((Object)options.getLoginPrivateKey()).andReturn(null);
        EasyMock.expect((Object)options.getRunScript()).andReturn((Object)Statements.exec((String)"echo foo"));
        EasyMock.expect((Object)strategy.credentialsMap.containsKey(new RegionAndName(region, userSuppliedKeyPair))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)userSuppliedKeyPair);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_reusesKeyWhenToldToWithRunScriptAndCredentialsSpecified() {
        String region = "ap-southeast-1";
        String group = "group";
        String userSuppliedKeyPair = "myKeyPair";
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getKeyPair()).andReturn((Object)userSuppliedKeyPair);
        EasyMock.expect((Object)options.getLoginPrivateKey()).andReturn((Object)CREDENTIALS.getPrivateKey()).atLeastOnce();
        EasyMock.expect((Object)strategy.credentialsMap.put(new RegionAndName(region, userSuppliedKeyPair), KEYPAIR)).andReturn(null);
        EasyMock.expect((Object)options.getRunScript()).andReturn((Object)Statements.exec((String)"echo foo"));
        EasyMock.expect((Object)strategy.credentialsMap.containsKey(new RegionAndName(region, userSuppliedKeyPair))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)userSuppliedKeyPair);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_createsNewKeyPairAndReturnsItsNameByDefault() throws ExecutionException {
        String region = "ap-southeast-1";
        String group = "group";
        Object userSuppliedKeyPair = null;
        boolean shouldAutomaticallyCreateKeyPair = true;
        String systemGeneratedKeyPairName = "systemGeneratedKeyPair";
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getKeyPair()).andReturn(userSuppliedKeyPair);
        EasyMock.expect((Object)options.shouldAutomaticallyCreateKeyPair()).andReturn((Object)shouldAutomaticallyCreateKeyPair);
        EasyMock.expect((Object)keyPair.getKeyName()).andReturn((Object)systemGeneratedKeyPairName).atLeastOnce();
        EasyMock.expect((Object)strategy.credentialsMap.containsKey(new RegionAndName(region, group))).andReturn((Object)true);
        EasyMock.expect(strategy.credentialsMap.get(new RegionAndName(region, group))).andReturn((Object)keyPair);
        EasyMock.expect((Object)options.getRunScript()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), (String)systemGeneratedKeyPairName);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_doesntCreateAKeyPairAndReturnsNullWhenToldNotTo() {
        String region = "ap-southeast-1";
        String group = "group";
        Object userSuppliedKeyPair = null;
        boolean shouldAutomaticallyCreateKeyPair = false;
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)options.getKeyPair()).andReturn(userSuppliedKeyPair);
        EasyMock.expect((Object)options.getRunScript()).andReturn(null);
        EasyMock.expect((Object)options.shouldAutomaticallyCreateKeyPair()).andReturn((Object)shouldAutomaticallyCreateKeyPair);
        EasyMock.replay((Object[])new Object[]{options});
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        Assert.assertEquals((String)strategy.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, (TemplateOptions)options), null);
        EasyMock.verify((Object[])new Object[]{options});
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testGetSecurityGroupsForTagAndOptions_createsNewGroupByDefaultWhenNoPortsAreSpecifiedWhenDoesntExist() throws ExecutionException {
        String region = "ap-southeast-1";
        String group = "group";
        String generatedMarkerGroup = "jclouds#group";
        ImmutableSet groupIds = ImmutableSet.of();
        int[] ports = new int[]{};
        boolean shouldAuthorizeSelf = true;
        ImmutableSet returnVal = ImmutableSet.of((Object)generatedMarkerGroup);
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        EasyMock.expect((Object)options.getGroups()).andReturn((Object)groupIds).atLeastOnce();
        EasyMock.expect((Object)options.getInboundPorts()).andReturn((Object)ports).atLeastOnce();
        RegionNameAndIngressRules regionNameAndIngressRules = new RegionNameAndIngressRules(region, generatedMarkerGroup, ports, shouldAuthorizeSelf);
        EasyMock.expect((Object)strategy.securityGroupMap.getUnchecked((Object)regionNameAndIngressRules)).andReturn((Object)group);
        EasyMock.replay((Object[])new Object[]{options});
        this.replayStrategy(strategy);
        Assert.assertEquals((Set)strategy.getSecurityGroupsForTagAndOptions(region, group, (TemplateOptions)options), (Set)returnVal);
        EasyMock.verify((Object[])new Object[]{options});
        this.verifyStrategy(strategy);
    }

    public void testGetSecurityGroupsForTagAndOptions_createsNewGroupByDefaultWhenPortsAreSpecifiedWhenDoesntExist() throws ExecutionException {
        String region = "ap-southeast-1";
        String group = "group";
        String generatedMarkerGroup = "jclouds#group";
        ImmutableSet groupIds = ImmutableSet.of();
        int[] ports = new int[]{22, 80};
        boolean shouldAuthorizeSelf = true;
        ImmutableSet returnVal = ImmutableSet.of((Object)generatedMarkerGroup);
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        EasyMock.expect((Object)options.getGroups()).andReturn((Object)groupIds).atLeastOnce();
        EasyMock.expect((Object)options.getInboundPorts()).andReturn((Object)ports).atLeastOnce();
        RegionNameAndIngressRules regionNameAndIngressRules = new RegionNameAndIngressRules(region, generatedMarkerGroup, ports, shouldAuthorizeSelf);
        EasyMock.expect((Object)strategy.securityGroupMap.getUnchecked((Object)regionNameAndIngressRules)).andReturn((Object)generatedMarkerGroup);
        EasyMock.replay((Object[])new Object[]{options});
        this.replayStrategy(strategy);
        Assert.assertEquals((Set)strategy.getSecurityGroupsForTagAndOptions(region, group, (TemplateOptions)options), (Set)returnVal);
        EasyMock.verify((Object[])new Object[]{options});
        this.verifyStrategy(strategy);
    }

    public void testGetSecurityGroupsForTagAndOptions_reusesGroupByDefaultWhenNoPortsAreSpecifiedWhenDoesExist() throws ExecutionException {
        String region = "ap-southeast-1";
        String group = "group";
        String generatedMarkerGroup = "jclouds#group";
        ImmutableSet groupIds = ImmutableSet.of();
        int[] ports = new int[]{};
        boolean shouldAuthorizeSelf = true;
        ImmutableSet returnVal = ImmutableSet.of((Object)generatedMarkerGroup);
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        EasyMock.expect((Object)options.getGroups()).andReturn((Object)groupIds).atLeastOnce();
        EasyMock.expect((Object)options.getInboundPorts()).andReturn((Object)ports).atLeastOnce();
        RegionNameAndIngressRules regionNameAndIngressRules = new RegionNameAndIngressRules(region, generatedMarkerGroup, ports, shouldAuthorizeSelf);
        EasyMock.expect((Object)strategy.securityGroupMap.getUnchecked((Object)regionNameAndIngressRules)).andReturn((Object)generatedMarkerGroup);
        EasyMock.replay((Object[])new Object[]{options});
        this.replayStrategy(strategy);
        Assert.assertEquals((Set)strategy.getSecurityGroupsForTagAndOptions(region, group, (TemplateOptions)options), (Set)returnVal);
        EasyMock.verify((Object[])new Object[]{options});
        this.verifyStrategy(strategy);
    }

    public void testGetSecurityGroupsForTagAndOptions_reusesGroupByDefaultWhenNoPortsAreSpecifiedWhenDoesExistAndAcceptsUserSuppliedGroups() {
        String region = "ap-southeast-1";
        String group = "group";
        String generatedMarkerGroup = "jclouds#group";
        ImmutableSet groupIds = ImmutableSet.of((Object)"group1", (Object)"group2");
        int[] ports = new int[]{};
        boolean shouldAuthorizeSelf = true;
        boolean groupExisted = true;
        ImmutableSet returnVal = ImmutableSet.of((Object)"group1", (Object)"group2");
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy = this.setupStrategy();
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);
        EasyMock.expect((Object)options.getGroups()).andReturn((Object)groupIds).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{options});
        this.replayStrategy(strategy);
        Assert.assertEquals((Set)strategy.getSecurityGroupsForTagAndOptions(region, group, (TemplateOptions)options), (Set)returnVal);
        EasyMock.verify((Object[])new Object[]{options});
        this.verifyStrategy(strategy);
    }

    private void verifyStrategy(CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy) {
        EasyMock.verify((Object[])new Object[]{strategy.makeKeyPair});
        EasyMock.verify((Object[])new Object[]{strategy.credentialsMap});
        EasyMock.verify((Object[])new Object[]{strategy.securityGroupMap});
    }

    private CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions setupStrategy() {
        Function makeKeyPair = (Function)EasyMock.createMock(Function.class);
        ConcurrentMap credentialsMap = (ConcurrentMap)EasyMock.createMock(ConcurrentMap.class);
        LoadingCache securityGroupMap = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        GroupNamingConvention.Factory namingConventionFactory = (GroupNamingConvention.Factory)EasyMock.createMock(GroupNamingConvention.Factory.class);
        GroupNamingConvention namingConvention = (GroupNamingConvention)EasyMock.createMock(GroupNamingConvention.class);
        EasyMock.expect((Object)namingConventionFactory.create()).andReturn((Object)namingConvention).anyTimes();
        EasyMock.expect((Object)namingConvention.sharedNameForGroup("group")).andReturn((Object)"jclouds#group").anyTimes();
        EasyMock.replay((Object[])new Object[]{namingConventionFactory});
        EasyMock.replay((Object[])new Object[]{namingConvention});
        return new CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions(makeKeyPair, credentialsMap, securityGroupMap, OPTIONS_PROVIDER, namingConventionFactory);
    }

    private void replayStrategy(CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions strategy) {
        EasyMock.replay((Object[])new Object[]{strategy.makeKeyPair});
        EasyMock.replay((Object[])new Object[]{strategy.credentialsMap});
        EasyMock.replay((Object[])new Object[]{strategy.securityGroupMap});
    }
}

