/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.AtomicNodeRunning;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.util.ComputeUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.PresentInstances;
import org.jclouds.ec2.compute.functions.RunningInstanceToNodeMetadata;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.ec2.compute.strategy.EC2CreateNodesInGroupThenAddToSet;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.features.ElasticIPAddressApi;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="EC2CreateNodesInGroupThenAddToSetTest")
public class EC2CreateNodesInGroupThenAddToSetTest {
    private static final Location REGION_AP_SOUTHEAST_1 = new LocationBuilder().scope(LocationScope.REGION).id("ap-southeast-1").description("ap-southeast-1").parent(new LocationBuilder().scope(LocationScope.PROVIDER).id("aws-ec2").description("aws-ec2").build()).build();
    private static final Location ZONE_AP_SOUTHEAST_1A = new LocationBuilder().scope(LocationScope.ZONE).id("ap-southeast-1a").description("ap-southeast-1a").parent(REGION_AP_SOUTHEAST_1).build();

    public void testIpAllocationThenAfterNodeRunningAssignThenUpdateCache() {
        Location location = ZONE_AP_SOUTHEAST_1A;
        String region = "ap-southeast-1";
        String zone = "ap-southeast-1a";
        String imageId = "ami1";
        String instanceCreatedId = "instance1";
        NodeMetadata nodeMetadata = new NodeMetadataBuilder().id(region + "/" + instanceCreatedId).providerId(instanceCreatedId).status(NodeMetadata.Status.RUNNING).build();
        EC2CreateNodesInGroupThenAddToSet strategy = this.setupStrategy(nodeMetadata);
        InputParams input = new InputParams(location);
        InstanceApi instanceClient = (InstanceApi)EasyMock.createMock(InstanceApi.class);
        ElasticIPAddressApi ipClient = (ElasticIPAddressApi)EasyMock.createMock(ElasticIPAddressApi.class);
        RunInstancesOptions ec2Options = (RunInstancesOptions)EasyMock.createMock(RunInstancesOptions.class);
        RunningInstance instance = (RunningInstance)EasyMock.createMock(RunningInstance.class);
        Reservation reservation = new Reservation(region, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of((Object)instance), "ownerId", "requesterId", "reservationId");
        strategy.autoAllocateElasticIps = true;
        EasyMock.expect((Object)input.template.clone()).andReturn((Object)input.template);
        EasyMock.expect((Object)strategy.client.getInstanceApi()).andReturn((Object)Optional.of((Object)instanceClient)).atLeastOnce();
        EasyMock.expect((Object)strategy.createKeyPairAndSecurityGroupsAsNeededAndReturncustomize.execute(region, input.tag, input.template)).andReturn((Object)ec2Options);
        EasyMock.expect((Object)strategy.client.getElasticIPAddressApi()).andReturn((Object)Optional.of((Object)ipClient)).atLeastOnce();
        EasyMock.expect((Object)input.template.getLocation()).andReturn((Object)input.location).atLeastOnce();
        EasyMock.expect((Object)input.template.getImage()).andReturn((Object)input.image).atLeastOnce();
        EasyMock.expect((Object)input.image.getProviderId()).andReturn((Object)imageId).atLeastOnce();
        EasyMock.expect((Object)ipClient.allocateAddressInRegion(region)).andReturn((Object)"1.1.1.1");
        EasyMock.expect((Object)strategy.runningInstanceToNodeMetadata.apply((Object)instance)).andReturn((Object)nodeMetadata).atLeastOnce();
        ipClient.associateAddressInRegion(region, "1.1.1.1", instanceCreatedId);
        strategy.elasticIpCache.put((Object)new RegionAndName(region, instanceCreatedId), (Object)"1.1.1.1");
        EasyMock.expect((Object)instanceClient.runInstancesInRegion(region, zone, imageId, 1, input.count, new RunInstancesOptions[]{ec2Options})).andReturn(Reservation.class.cast(reservation));
        EasyMock.expect((Object)instance.getId()).andReturn((Object)instanceCreatedId).atLeastOnce();
        LoginCredentials creds = LoginCredentials.builder().user("foo").privateKey("bar").build();
        EasyMock.expect((Object)strategy.instanceToCredentials.apply((Object)instance)).andReturn((Object)Optional.of((Object)creds));
        EasyMock.expect((Object)instance.getRegion()).andReturn((Object)region).atLeastOnce();
        EasyMock.expect((Object)strategy.credentialStore.put("node#" + region + "/" + instanceCreatedId, creds)).andReturn(null);
        EasyMock.expect((Object)strategy.presentInstances.apply((Set)ImmutableSet.of((Object)new RegionAndName(region, instanceCreatedId)))).andReturn((Object)ImmutableSet.of((Object)instance));
        EasyMock.expect((Object)input.template.getOptions()).andReturn((Object)input.options).atLeastOnce();
        EasyMock.expect((Object)input.options.getLoginUser()).andReturn(null);
        EasyMock.expect((Object)input.options.getLoginPassword()).andReturn(null);
        EasyMock.expect((Object)input.options.getLoginPrivateKey()).andReturn(null);
        EasyMock.expect((Object)input.options.shouldAuthenticateSudo()).andReturn(null);
        EasyMock.expect((Object)strategy.utils.customizeNodesAndAddToGoodMapOrPutExceptionIntoBadMap((TemplateOptions)EasyMock.eq((Object)input.options), EC2CreateNodesInGroupThenAddToSetTest.containsNodeMetadata(nodeMetadata), (Set)EasyMock.eq(input.nodes), (Map)EasyMock.eq(input.badNodes), (Multimap)EasyMock.eq(input.customization))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{instanceClient});
        EasyMock.replay((Object[])new Object[]{ipClient});
        EasyMock.replay((Object[])new Object[]{ec2Options});
        EasyMock.replay((Object[])new Object[]{instance});
        input.replayMe();
        this.replayStrategy(strategy);
        strategy.execute(input.tag, input.count, input.template, input.nodes, input.badNodes, input.customization);
        EasyMock.verify((Object[])new Object[]{instanceClient});
        EasyMock.verify((Object[])new Object[]{ipClient});
        EasyMock.verify((Object[])new Object[]{ec2Options});
        EasyMock.verify((Object[])new Object[]{instance});
        input.verifyMe();
        this.verifyStrategy(strategy);
    }

    @Test
    public void testZoneAsALocation() {
        this.assertRegionAndZoneForLocation(ZONE_AP_SOUTHEAST_1A, "ap-southeast-1", "ap-southeast-1a");
    }

    @Test
    public void testRegionAsALocation() {
        this.assertRegionAndZoneForLocation(REGION_AP_SOUTHEAST_1, "ap-southeast-1", null);
    }

    public static Iterable<NodeMetadata> containsNodeMetadata(final NodeMetadata in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("contains(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return Iterables.contains((Iterable)((Iterable)arg), (Object)in);
            }
        });
        return null;
    }

    private void assertRegionAndZoneForLocation(Location location, String region, String zone) {
        String imageId = "ami1";
        String instanceCreatedId = "instance1";
        NodeMetadata nodeMetadata = new NodeMetadataBuilder().id(region + "/" + instanceCreatedId).providerId(instanceCreatedId).status(NodeMetadata.Status.RUNNING).build();
        EC2CreateNodesInGroupThenAddToSet strategy = this.setupStrategy(nodeMetadata);
        InputParams input = new InputParams(location);
        InstanceApi instanceClient = (InstanceApi)EasyMock.createMock(InstanceApi.class);
        RunInstancesOptions ec2Options = (RunInstancesOptions)EasyMock.createMock(RunInstancesOptions.class);
        RunningInstance instance = (RunningInstance)EasyMock.createMock(RunningInstance.class);
        Reservation reservation = new Reservation(region, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of((Object)instance), "ownerId", "requesterId", "reservationId");
        EasyMock.expect((Object)input.template.clone()).andReturn((Object)input.template);
        EasyMock.expect((Object)strategy.client.getInstanceApi()).andReturn((Object)Optional.of((Object)instanceClient)).atLeastOnce();
        EasyMock.expect((Object)strategy.createKeyPairAndSecurityGroupsAsNeededAndReturncustomize.execute(region, input.tag, input.template)).andReturn((Object)ec2Options);
        EasyMock.expect((Object)input.template.getLocation()).andReturn((Object)input.location).atLeastOnce();
        EasyMock.expect((Object)input.template.getImage()).andReturn((Object)input.image).atLeastOnce();
        EasyMock.expect((Object)input.image.getProviderId()).andReturn((Object)imageId).atLeastOnce();
        EasyMock.expect((Object)instanceClient.runInstancesInRegion(region, zone, imageId, 1, input.count, new RunInstancesOptions[]{ec2Options})).andReturn(Reservation.class.cast(reservation));
        EasyMock.expect((Object)instance.getId()).andReturn((Object)instanceCreatedId).atLeastOnce();
        LoginCredentials creds = LoginCredentials.builder().user("foo").privateKey("bar").build();
        EasyMock.expect((Object)strategy.instanceToCredentials.apply((Object)instance)).andReturn((Object)Optional.of((Object)creds));
        EasyMock.expect((Object)instance.getRegion()).andReturn((Object)region).atLeastOnce();
        EasyMock.expect((Object)strategy.credentialStore.put("node#" + region + "/" + instanceCreatedId, creds)).andReturn(null);
        EasyMock.expect((Object)strategy.presentInstances.apply((Set)ImmutableSet.of((Object)new RegionAndName(region, instanceCreatedId)))).andReturn((Object)ImmutableSet.of((Object)instance));
        EasyMock.expect((Object)input.template.getOptions()).andReturn((Object)input.options).atLeastOnce();
        EasyMock.expect((Object)input.options.getLoginUser()).andReturn(null);
        EasyMock.expect((Object)input.options.getLoginPassword()).andReturn(null);
        EasyMock.expect((Object)input.options.getLoginPrivateKey()).andReturn(null);
        EasyMock.expect((Object)input.options.shouldAuthenticateSudo()).andReturn(null);
        EasyMock.expect((Object)strategy.runningInstanceToNodeMetadata.apply((Object)instance)).andReturn((Object)nodeMetadata);
        EasyMock.expect((Object)strategy.utils.customizeNodesAndAddToGoodMapOrPutExceptionIntoBadMap((TemplateOptions)EasyMock.eq((Object)input.options), EC2CreateNodesInGroupThenAddToSetTest.containsNodeMetadata(nodeMetadata), (Set)EasyMock.eq(input.nodes), (Map)EasyMock.eq(input.badNodes), (Multimap)EasyMock.eq(input.customization))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{instanceClient});
        EasyMock.replay((Object[])new Object[]{ec2Options});
        EasyMock.replay((Object[])new Object[]{instance});
        input.replayMe();
        this.replayStrategy(strategy);
        strategy.execute(input.tag, input.count, input.template, input.nodes, input.badNodes, input.customization);
        EasyMock.verify((Object[])new Object[]{instanceClient});
        EasyMock.verify((Object[])new Object[]{ec2Options});
        EasyMock.verify((Object[])new Object[]{instance});
        input.verifyMe();
        this.verifyStrategy(strategy);
    }

    private void verifyStrategy(EC2CreateNodesInGroupThenAddToSet strategy) {
        EasyMock.verify((Object[])new Object[]{strategy.createKeyPairAndSecurityGroupsAsNeededAndReturncustomize});
        EasyMock.verify((Object[])new Object[]{strategy.client});
        EasyMock.verify((Object[])new Object[]{strategy.elasticIpCache});
        EasyMock.verify((Object[])new Object[]{strategy.presentInstances});
        EasyMock.verify((Object[])new Object[]{strategy.runningInstanceToNodeMetadata});
        EasyMock.verify((Object[])new Object[]{strategy.instanceToCredentials});
        EasyMock.verify((Object[])new Object[]{strategy.credentialStore});
        EasyMock.verify((Object[])new Object[]{strategy.utils});
    }

    private EC2CreateNodesInGroupThenAddToSet setupStrategy(final NodeMetadata node) {
        EC2Api client = (EC2Api)EasyMock.createMock(EC2Api.class);
        CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions createKeyPairAndSecurityGroupsAsNeededAndReturncustomize = (CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions)EasyMock.createMock(CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class);
        PresentInstances presentInstances = (PresentInstances)EasyMock.createMock(PresentInstances.class);
        RunningInstanceToNodeMetadata runningInstanceToNodeMetadata = (RunningInstanceToNodeMetadata)EasyMock.createMock(RunningInstanceToNodeMetadata.class);
        LoadingCache instanceToCredentials = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        LoadingCache elasticIpCache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        GetNodeMetadataStrategy nodeRunning = new GetNodeMetadataStrategy(){

            public NodeMetadata getNode(String input) {
                Assert.assertEquals((String)input, (String)node.getId());
                return node;
            }
        };
        Map credentialStore = (Map)EasyMock.createMock(Map.class);
        ComputeUtils utils = (ComputeUtils)EasyMock.createMock(ComputeUtils.class);
        return new EC2CreateNodesInGroupThenAddToSet(client, elasticIpCache, (Predicate)new AtomicNodeRunning(nodeRunning), createKeyPairAndSecurityGroupsAsNeededAndReturncustomize, presentInstances, (Function)runningInstanceToNodeMetadata, instanceToCredentials, credentialStore, utils);
    }

    private void replayStrategy(EC2CreateNodesInGroupThenAddToSet strategy) {
        EasyMock.replay((Object[])new Object[]{strategy.createKeyPairAndSecurityGroupsAsNeededAndReturncustomize});
        EasyMock.replay((Object[])new Object[]{strategy.client});
        EasyMock.replay((Object[])new Object[]{strategy.elasticIpCache});
        EasyMock.replay((Object[])new Object[]{strategy.presentInstances});
        EasyMock.replay((Object[])new Object[]{strategy.runningInstanceToNodeMetadata});
        EasyMock.replay((Object[])new Object[]{strategy.instanceToCredentials});
        EasyMock.replay((Object[])new Object[]{strategy.credentialStore});
        EasyMock.replay((Object[])new Object[]{strategy.utils});
    }

    private static class InputParams {
        String tag = "foo";
        int count = 1;
        Template template = (Template)EasyMock.createMock(Template.class);
        Set<NodeMetadata> nodes = (Set)EasyMock.createMock(Set.class);
        Map<NodeMetadata, Exception> badNodes = (Map)EasyMock.createMock(Map.class);
        Multimap<NodeMetadata, CustomizationResponse> customization = (Multimap)EasyMock.createMock(Multimap.class);
        Hardware hardware = (Hardware)EasyMock.createMock(Hardware.class);
        Image image = (Image)EasyMock.createMock(Image.class);
        final Location location;
        EC2TemplateOptions options = (EC2TemplateOptions)EasyMock.createMock(EC2TemplateOptions.class);

        public InputParams(Location location) {
            this.location = location;
        }

        void replayMe() {
            EasyMock.replay((Object[])new Object[]{this.template});
            EasyMock.replay((Object[])new Object[]{this.hardware});
            EasyMock.replay((Object[])new Object[]{this.image});
            EasyMock.replay((Object[])new Object[]{this.nodes});
            EasyMock.replay((Object[])new Object[]{this.badNodes});
            EasyMock.replay((Object[])new Object[]{this.customization});
            EasyMock.replay((Object[])new Object[]{this.options});
        }

        void verifyMe() {
            EasyMock.verify((Object[])new Object[]{this.template});
            EasyMock.verify((Object[])new Object[]{this.hardware});
            EasyMock.verify((Object[])new Object[]{this.image});
            EasyMock.verify((Object[])new Object[]{this.nodes});
            EasyMock.verify((Object[])new Object[]{this.badNodes});
            EasyMock.verify((Object[])new Object[]{this.customization});
            EasyMock.verify((Object[])new Object[]{this.options});
        }
    }
}

