/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Set;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.features.AMIApi;
import org.jclouds.ec2.internal.BaseEC2ApiExpectTest;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AMIApiExpectTest")
public class AMIApiExpectTest
extends BaseEC2ApiExpectTest<EC2Api> {
    HttpRequest filter = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeImages"}).addFormParam("Filter.1.Name", new String[]{"owner-id"}).addFormParam("Filter.1.Value.1", new String[]{"206029621532"}).addFormParam("Signature", new String[]{"BxOCrCYJujtaUqSPagRvv1ki76veVBiKK3yWHvRWgR0%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2012-04-16T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testFilterWhenResponseIs2xx() {
        HttpResponse filterResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_images.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        Image image = (Image)Iterables.getOnlyElement((Iterable)((AMIApi)apiWhenExist.getAMIApi().get()).describeImagesInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"owner-id", (Object)"206029621532").build(), new DescribeImagesOptions[0]));
        Assert.assertEquals((String)image.getId(), (String)"ami-be3adfd7");
    }

    public void testFilterWhenResponseIs404() {
        HttpResponse filterResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenNotExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        Assert.assertEquals((Set)((AMIApi)apiWhenNotExist.getAMIApi().get()).describeImagesInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"owner-id", (Object)"206029621532").build(), new DescribeImagesOptions[0]), (Set)ImmutableSet.of());
    }
}

