/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.features.AMIApi;
import org.jclouds.ec2.features.ElasticBlockStoreApi;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.options.CreateSnapshotOptions;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.ec2.options.RegisterImageBackedByEbsOptions;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.ec2.predicates.InstanceStateRunning;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AMIApiLiveTest
extends BaseComputeServiceContextLiveTest {
    private TemplateBuilderSpec ebsTemplate;
    protected EC2Api ec2Api;
    protected AMIApi client;
    protected Predicate<RunningInstance> runningTester;
    protected Set<String> imagesToDeregister = Sets.newHashSet();
    protected Set<String> snapshotsToDelete = Sets.newHashSet();
    protected String regionId;
    protected String ebsBackedImageId;
    protected String ebsBackedImageName = "jcloudstest1";
    protected String imageId;

    public AMIApiLiveTest() {
        this.provider = "ec2";
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        String ebsSpec = (String)Preconditions.checkNotNull((Object)this.setIfTestSystemPropertyPresent(overrides, this.provider + ".ebs-template"), (Object)(this.provider + ".ebs-template"));
        this.ebsTemplate = TemplateBuilderSpec.parse((String)ebsSpec);
        return overrides;
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Api = (EC2Api)((ComputeServiceContext)this.view).unwrapApi(EC2Api.class);
        this.runningTester = Predicates2.retry((Predicate)new InstanceStateRunning(this.ec2Api), (long)600L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        this.client = (AMIApi)this.ec2Api.getAMIApi().get();
        if (this.ebsTemplate != null) {
            Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().from(this.ebsTemplate).build();
            this.regionId = template.getLocation().getId();
            this.imageId = template.getImage().getProviderId();
            for (Image image : this.client.describeImagesInRegionWithFilter(this.regionId, (Multimap)ImmutableMultimap.builder().put((Object)"name", (Object)this.ebsBackedImageName).build(), new DescribeImagesOptions[0])) {
                if (!this.ebsBackedImageName.equals(image.getName())) continue;
                this.client.deregisterImageInRegion(this.regionId, image.getId());
            }
        }
    }

    public void testDescribeImageNotExists() {
        Assert.assertEquals((int)this.client.describeImagesInRegion(null, new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{"ami-cdf819a3"})}).size(), (int)0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDescribeImageBadId() {
        this.client.describeImagesInRegion(null, new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{"asdaasdsa"})});
    }

    public void testDescribeImages() {
        String region = (String)Iterables.getFirst((Iterable)this.ec2Api.getConfiguredRegions(), null);
        Assert.assertNotNull((Object)region, (String)"region should not be null");
        Set allResults = this.client.describeImagesInRegion(region, new DescribeImagesOptions[0]);
        Assert.assertNotNull((Object)allResults);
        Assert.assertTrue((allResults.size() >= 2 ? 1 : 0) != 0);
        Iterator iterator = allResults.iterator();
        String id1 = ((Image)iterator.next()).getId();
        String id2 = ((Image)iterator.next()).getId();
        Set twoResults = this.client.describeImagesInRegion(region, new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{id1, id2})});
        Assert.assertNotNull((Object)twoResults);
        Assert.assertEquals((int)twoResults.size(), (int)2);
        iterator = twoResults.iterator();
        Assert.assertEquals((String)((Image)iterator.next()).getId(), (String)id1);
        Assert.assertEquals((String)((Image)iterator.next()).getId(), (String)id2);
    }

    @Test
    public void testDescribeImagesWithFilter() {
        String region = (String)Iterables.getFirst((Iterable)this.ec2Api.getConfiguredRegions(), null);
        Assert.assertNotNull((Object)region, (String)"region should not be null");
        Set allResults = this.client.describeImagesInRegion(region, new DescribeImagesOptions[0]);
        Assert.assertNotNull((Object)allResults);
        Assert.assertTrue((allResults.size() >= 2 ? 1 : 0) != 0);
        String id1 = ((Image)allResults.iterator().next()).getId();
        Set filterResult = this.client.describeImagesInRegionWithFilter(region, (Multimap)ImmutableMultimap.builder().put((Object)"image-id", (Object)id1).build(), new DescribeImagesOptions[0]);
        Assert.assertNotNull((Object)filterResult);
        Assert.assertEquals((int)filterResult.size(), (int)1);
        Assert.assertEquals((String)((Image)filterResult.iterator().next()).getId(), (String)id1);
    }

    @Test(expectedExceptions={AWSResponseException.class})
    public void testDescribeImagesWithInvalidFilter() {
        String region = (String)Iterables.getFirst((Iterable)this.ec2Api.getConfiguredRegions(), null);
        Assert.assertNotNull((Object)region, (String)"region should not be null");
        Set allResults = this.client.describeImagesInRegion(region, new DescribeImagesOptions[0]);
        Assert.assertNotNull((Object)allResults);
        Assert.assertTrue((allResults.size() >= 2 ? 1 : 0) != 0);
        String id1 = ((Image)allResults.iterator().next()).getId();
        Set filterResult = this.client.describeImagesInRegionWithFilter(region, (Multimap)ImmutableMultimap.builder().put((Object)"invalid-filter-id", (Object)id1).build(), new DescribeImagesOptions[0]);
        Assert.assertNotNull((Object)filterResult);
        Assert.assertEquals((int)filterResult.size(), (int)1);
        Assert.assertEquals((String)((Image)filterResult.iterator().next()).getId(), (String)id1);
    }

    @Test
    public void testCreateAndListEBSBackedImage() throws Exception {
        Snapshot snapshot = this.createSnapshot();
        int sizeBefore = this.client.describeImagesInRegionWithFilter(this.regionId, (Multimap)ImmutableMultimap.builder().put((Object)"name", (Object)this.ebsBackedImageName).build(), new DescribeImagesOptions[0]).size();
        this.ebsBackedImageId = this.client.registerUnixImageBackedByEbsInRegion(this.regionId, this.ebsBackedImageName, snapshot.getId(), new RegisterImageBackedByEbsOptions[]{RegisterImageBackedByEbsOptions.Builder.addNewBlockDevice((String)"/dev/sda2", (String)"myvirtual", (int)1).withDescription("adrian")});
        this.imagesToDeregister.add(this.ebsBackedImageId);
        Image ebsBackedImage = (Image)Iterables.getOnlyElement((Iterable)this.client.describeImagesInRegion(this.regionId, new DescribeImagesOptions[]{DescribeImagesOptions.Builder.imageIds((String[])new String[]{this.ebsBackedImageId})}));
        Assert.assertEquals((String)ebsBackedImage.getName(), (String)this.ebsBackedImageName);
        Assert.assertEquals((Object)ebsBackedImage.getImageType(), (Object)Image.ImageType.MACHINE);
        Assert.assertEquals((Object)ebsBackedImage.getRootDeviceType(), (Object)RootDeviceType.EBS);
        Assert.assertEquals((String)ebsBackedImage.getRootDeviceName(), (String)"/dev/sda1");
        Assert.assertEquals((String)ebsBackedImage.getDescription(), (String)"adrian");
        Assert.assertEquals(ebsBackedImage.getEbsBlockDevices().entrySet(), (Set)ImmutableMap.of((Object)"/dev/sda1", (Object)new Image.EbsBlockDevice(snapshot.getId(), (long)snapshot.getVolumeSize(), true), (Object)"/dev/sda2", (Object)new Image.EbsBlockDevice(null, 1L, false)).entrySet());
        int after = this.client.describeImagesInRegionWithFilter(this.regionId, (Multimap)ImmutableMultimap.builder().put((Object)"name", (Object)this.ebsBackedImageName).build(), new DescribeImagesOptions[0]).size();
        Assert.assertEquals((int)after, (int)(sizeBefore + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Snapshot createSnapshot() throws RunNodesException {
        Snapshot snapshot;
        block3: {
            String instanceId = null;
            try {
                RunningInstance instance = (RunningInstance)Iterables.getOnlyElement((Iterable)Iterables.concat((Iterable[])new Iterable[]{((InstanceApi)this.ec2Api.getInstanceApi().get()).runInstancesInRegion(this.regionId, null, this.imageId, 1, 1, new RunInstancesOptions[0])}));
                instanceId = instance.getId();
                Assert.assertTrue((boolean)this.runningTester.apply((Object)instance), (String)(instanceId + "didn't achieve the state running!"));
                instance = (RunningInstance)Iterables.getOnlyElement((Iterable)Iterables.concat((Iterable)((InstanceApi)this.ec2Api.getInstanceApi().get()).describeInstancesInRegion(this.regionId, new String[]{instanceId})));
                BlockDevice device = (BlockDevice)instance.getEbsBlockDevices().get("/dev/sda1");
                Assert.assertNotNull((Object)device, (String)("device: /dev/sda1 not present on: " + instance));
                Snapshot snapshot2 = ((ElasticBlockStoreApi)this.ec2Api.getElasticBlockStoreApi().get()).createSnapshotInRegion(this.regionId, device.getVolumeId(), new CreateSnapshotOptions[0]);
                this.snapshotsToDelete.add(snapshot2.getId());
                snapshot = snapshot2;
                if (instanceId == null) break block3;
            }
            catch (Throwable throwable) {
                if (instanceId != null) {
                    ((InstanceApi)this.ec2Api.getInstanceApi().get()).terminateInstancesInRegion(this.regionId, new String[]{instanceId});
                }
                throw throwable;
            }
            ((InstanceApi)this.ec2Api.getInstanceApi().get()).terminateInstancesInRegion(this.regionId, new String[]{instanceId});
        }
        return snapshot;
    }

    @Test(dependsOnMethods={"testCreateAndListEBSBackedImage"})
    public void testGetLaunchPermissionForImage() {
        this.client.getLaunchPermissionForImageInRegion(this.regionId, this.ebsBackedImageId);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        for (String imageId : this.imagesToDeregister) {
            this.client.deregisterImageInRegion(this.regionId, imageId);
        }
        for (String snapshotId : this.snapshotsToDelete) {
            ((ElasticBlockStoreApi)this.ec2Api.getElasticBlockStoreApi().get()).deleteSnapshotInRegion(this.regionId, snapshotId);
        }
        super.tearDownContext();
    }
}

