/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.ec2.features.AMIApi;
import org.jclouds.ec2.features.BaseEC2ApiTest;
import org.jclouds.ec2.options.CreateImageOptions;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.ec2.options.RegisterImageBackedByEbsOptions;
import org.jclouds.ec2.options.RegisterImageOptions;
import org.jclouds.ec2.xml.BlockDeviceMappingHandler;
import org.jclouds.ec2.xml.DescribeImagesResponseHandler;
import org.jclouds.ec2.xml.ImageIdHandler;
import org.jclouds.ec2.xml.PermissionHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AMIApiTest")
public class AMIApiTest
extends BaseEC2ApiTest<AMIApi> {
    HttpRequest createImage = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"CreateImage"}).addFormParam("InstanceId", new String[]{"instanceId"}).addFormParam("Name", new String[]{"name"}).addFormParam("Signature", new String[]{"MuMtOMs697BLVks2RUZUNeLdVCo6NXPHuDhh0nmNtvc%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest createImageOptions = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"CreateImage"}).addFormParam("Description", new String[]{"description"}).addFormParam("InstanceId", new String[]{"instanceId"}).addFormParam("Name", new String[]{"name"}).addFormParam("NoReboot", new String[]{"true"}).addFormParam("Signature", new String[]{"8SgbaWihxOICMXDLvwk3ahy/99nhZvTvbno%2B8dMyvJg%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest describeImages = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeImages"}).addFormParam("Signature", new String[]{"hQxNAaRVX6OvXV0IKgx1vV0FoNbRyuHQ2fhRhaPJnS8%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest describeImagesOptions = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeImages"}).addFormParam("ExecutableBy", new String[]{"me"}).addFormParam("ImageId.1", new String[]{"1"}).addFormParam("ImageId.2", new String[]{"2"}).addFormParam("Owner.1", new String[]{"fred"}).addFormParam("Owner.2", new String[]{"nancy"}).addFormParam("Signature", new String[]{"cIft3g1fwMu52NgB0En9NtHyXjVhmeSx7TBP7YR%2BTvI%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest deregisterImage = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DeregisterImage"}).addFormParam("ImageId", new String[]{"imageId"}).addFormParam("Signature", new String[]{"tm6nGoPPJh7xt5TSdV5Ov0DJvcGTAW%2BYSfXL7j%2BTkOA%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest registerImageFromManifest = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"RegisterImage"}).addFormParam("ImageLocation", new String[]{"pathToManifest"}).addFormParam("Name", new String[]{"name"}).addFormParam("Signature", new String[]{"Ie7k7w4Bdki3uCGeSFGdJ5EKrp/ohkHvWwivbIaVLEM%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest registerImageFromManifestOptions = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"RegisterImage"}).addFormParam("Description", new String[]{"description"}).addFormParam("ImageLocation", new String[]{"pathToManifest"}).addFormParam("Name", new String[]{"name"}).addFormParam("Signature", new String[]{"ilWV1eAWW6kTK/jHliQ%2BIkzJR4DRNy4ye%2BSKtnUjjDs%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest registerImageBackedByEBS = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"RegisterImage"}).addFormParam("BlockDeviceMapping.0.DeviceName", new String[]{"/dev/sda1"}).addFormParam("BlockDeviceMapping.0.Ebs.SnapshotId", new String[]{"snapshotId"}).addFormParam("Name", new String[]{"imageName"}).addFormParam("RootDeviceName", new String[]{"/dev/sda1"}).addFormParam("Signature", new String[]{"ZbZcY6uwxPbD65jFmiNZXoWeHY/2zqRuGuDmTfkt84A%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest registerImageBackedByEBSOptions = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"RegisterImage"}).addFormParam("BlockDeviceMapping.0.DeviceName", new String[]{"/dev/sda1"}).addFormParam("BlockDeviceMapping.0.Ebs.SnapshotId", new String[]{"snapshotId"}).addFormParam("BlockDeviceMapping.1.DeviceName", new String[]{"/dev/device"}).addFormParam("BlockDeviceMapping.1.Ebs.DeleteOnTermination", new String[]{"false"}).addFormParam("BlockDeviceMapping.1.Ebs.SnapshotId", new String[]{"snapshot"}).addFormParam("BlockDeviceMapping.2.DeviceName", new String[]{"/dev/newdevice"}).addFormParam("BlockDeviceMapping.2.Ebs.DeleteOnTermination", new String[]{"false"}).addFormParam("BlockDeviceMapping.2.Ebs.VolumeSize", new String[]{"100"}).addFormParam("BlockDeviceMapping.2.VirtualName", new String[]{"newblock"}).addFormParam("Description", new String[]{"description"}).addFormParam("Name", new String[]{"imageName"}).addFormParam("RootDeviceName", new String[]{"/dev/sda1"}).addFormParam("Signature", new String[]{"DrNujyZMGrKvuw73A7ObFTThXvc/MRfNqjvIy8gey5g%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest getBlockDeviceMappingsForImage = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeImageAttribute"}).addFormParam("Attribute", new String[]{"blockDeviceMapping"}).addFormParam("ImageId", new String[]{"imageId"}).addFormParam("Signature", new String[]{"MJCIc1roG%2BnIWxRSUqV9KP9Wc4AWuuiNkxeDSih5/mI%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest getLaunchPermissionForImage = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeImageAttribute"}).addFormParam("Attribute", new String[]{"launchPermission"}).addFormParam("ImageId", new String[]{"imageId"}).addFormParam("Signature", new String[]{"iN7JbsAhM1NAES3o%2BOw8BaaFJ%2B1g9imBjcU4mFCyrxM%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest addLaunchPermission = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ModifyImageAttribute"}).addFormParam("Attribute", new String[]{"launchPermission"}).addFormParam("ImageId", new String[]{"imageId"}).addFormParam("OperationType", new String[]{"add"}).addFormParam("Signature", new String[]{"ZuMuzW/iQDRURhUJaBzvoAdNJrE454y6X0jM24lcxxk%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("UserGroup.1", new String[]{"all"}).addFormParam("UserId.1", new String[]{"bob"}).addFormParam("UserId.2", new String[]{"sue"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest removeLaunchPermission = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ModifyImageAttribute"}).addFormParam("Attribute", new String[]{"launchPermission"}).addFormParam("ImageId", new String[]{"imageId"}).addFormParam("OperationType", new String[]{"remove"}).addFormParam("Signature", new String[]{"HreSEawbVaUp/UMicCJbhrx%2BmoX01f2pEphJCPz8/5g%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("UserGroup.1", new String[]{"all"}).addFormParam("UserId.1", new String[]{"bob"}).addFormParam("UserId.2", new String[]{"sue"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest resetLaunchPermissionsOnImage = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ResetImageAttribute"}).addFormParam("Attribute", new String[]{"launchPermission"}).addFormParam("ImageId", new String[]{"imageId"}).addFormParam("Signature", new String[]{"fVCR9aGYvNX/Jt1/uqBGcUQRLrHwxtcvmNYKzpul1P4%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testCreateImage() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"createImageInRegion", (Class[])new Class[]{String.class, String.class, String.class, CreateImageOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "name", "instanceId"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.createImage.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ImageIdHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateImageOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"createImageInRegion", (Class[])new Class[]{String.class, String.class, String.class, CreateImageOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "name", "instanceId", new CreateImageOptions().withDescription("description").noReboot()}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.createImageOptions.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ImageIdHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeImages() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"describeImagesInRegion", (Class[])new Class[]{String.class, DescribeImagesOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.describeImages.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeImagesResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeImagesOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"describeImagesInRegion", (Class[])new Class[]{String.class, DescribeImagesOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, DescribeImagesOptions.Builder.executableBy((String)"me").ownedBy(new String[]{"fred", "nancy"}).imageIds(new String[]{"1", "2"})}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.describeImagesOptions.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeImagesResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeregisterImage() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"deregisterImageInRegion", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "imageId"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.deregisterImage.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRegisterImageFromManifest() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"registerImageFromManifestInRegion", (Class[])new Class[]{String.class, String.class, String.class, RegisterImageOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "name", "pathToManifest"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.registerImageFromManifest.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ImageIdHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRegisterImageFromManifestOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"registerImageFromManifestInRegion", (Class[])new Class[]{String.class, String.class, String.class, RegisterImageOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "name", "pathToManifest", new RegisterImageOptions().withDescription("description")}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.registerImageFromManifestOptions.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ImageIdHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRegisterImageBackedByEBS() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"registerUnixImageBackedByEbsInRegion", (Class[])new Class[]{String.class, String.class, String.class, RegisterImageBackedByEbsOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "imageName", "snapshotId"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.registerImageBackedByEBS.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ImageIdHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRegisterImageBackedByEBSOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"registerUnixImageBackedByEbsInRegion", (Class[])new Class[]{String.class, String.class, String.class, RegisterImageBackedByEbsOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "imageName", "snapshotId", new RegisterImageBackedByEbsOptions().withDescription("description").addBlockDeviceFromSnapshot("/dev/device", null, "snapshot").addNewBlockDevice("/dev/newdevice", "newblock", 100)}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.registerImageBackedByEBSOptions.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, ImageIdHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetBlockDeviceMappingsForImage() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"getBlockDeviceMappingsForImageInRegion", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "imageId"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.getBlockDeviceMappingsForImage.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, BlockDeviceMappingHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetLaunchPermissionForImage() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"getLaunchPermissionForImageInRegion", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "imageId"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.getLaunchPermissionForImage.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, PermissionHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddLaunchPermissionsToImage() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"addLaunchPermissionsToImageInRegion", (Class[])new Class[]{String.class, Iterable.class, Iterable.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, ImmutableList.of((Object)"bob", (Object)"sue"), ImmutableList.of((Object)"all"), "imageId"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.addLaunchPermission.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRemoveLaunchPermissionsFromImage() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"removeLaunchPermissionsFromImageInRegion", (Class[])new Class[]{String.class, Iterable.class, Iterable.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, ImmutableList.of((Object)"bob", (Object)"sue"), ImmutableList.of((Object)"all"), "imageId"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.removeLaunchPermission.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testResetLaunchPermissionsOnImage() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(AMIApi.class, (String)"resetLaunchPermissionsOnImageInRegion", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "imageId"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.resetLaunchPermissionsOnImage.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }
}

