/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.AvailabilityZoneInfo;
import org.jclouds.ec2.features.AvailabilityZoneAndRegionApi;
import org.jclouds.ec2.options.DescribeAvailabilityZonesOptions;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="AvailabilityZoneAndRegionApiLiveTest")
public class AvailabilityZoneAndRegionApiLiveTest
extends BaseComputeServiceContextLiveTest {
    private EC2Api ec2Api;
    private AvailabilityZoneAndRegionApi client;

    public AvailabilityZoneAndRegionApiLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Api = (EC2Api)((ComputeServiceContext)this.view).unwrapApi(EC2Api.class);
        this.client = (AvailabilityZoneAndRegionApi)this.ec2Api.getAvailabilityZoneAndRegionApi().get();
    }

    public void testDescribeAvailabilityZones() {
        for (String region : this.ec2Api.getConfiguredRegions()) {
            Set allResults = this.client.describeAvailabilityZonesInRegion(region, new DescribeAvailabilityZonesOptions[0]);
            Assert.assertNotNull((Object)allResults);
            assert (!allResults.isEmpty()) : allResults.size();
            Iterator iterator = allResults.iterator();
            String id1 = ((AvailabilityZoneInfo)iterator.next()).getZone();
            Set oneResult = this.client.describeAvailabilityZonesInRegion(region, new DescribeAvailabilityZonesOptions[]{DescribeAvailabilityZonesOptions.Builder.availabilityZones((String[])new String[]{id1})});
            Assert.assertNotNull((Object)oneResult);
            Assert.assertEquals((int)oneResult.size(), (int)1);
            iterator = allResults.iterator();
            Assert.assertEquals((String)((AvailabilityZoneInfo)iterator.next()).getZone(), (String)id1);
        }
    }

    public void testDescribeRegions() {
        TreeMap allResults = Maps.newTreeMap();
        allResults.putAll(this.client.describeRegions(new DescribeRegionsOptions[0]));
        Assert.assertNotNull((Object)allResults);
        assert (!allResults.isEmpty()) : allResults.size();
        Iterator iterator = allResults.entrySet().iterator();
        String r1 = (String)iterator.next().getKey();
        TreeMap oneResult = Maps.newTreeMap();
        oneResult.putAll(this.client.describeRegions(new DescribeRegionsOptions[]{DescribeRegionsOptions.Builder.regions((String[])new String[]{r1})}));
        Assert.assertNotNull((Object)oneResult);
        Assert.assertEquals((int)oneResult.size(), (int)1);
        iterator = oneResult.entrySet().iterator();
        Assert.assertEquals((String)((String)iterator.next().getKey()), (String)r1);
    }
}

