/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.features.ElasticBlockStoreApi;
import org.jclouds.ec2.internal.BaseEC2ApiExpectTest;
import org.jclouds.ec2.options.DescribeSnapshotsOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EC2ElasticBlockStoreApiExpectTest")
public class EC2ElasticBlockStoreApiExpectTest
extends BaseEC2ApiExpectTest<EC2Api> {
    Volume creating;
    HttpRequest filterVolumes;
    HttpRequest filterSnapshots;

    public EC2ElasticBlockStoreApiExpectTest() {
        this.creating = Volume.builder().id("vol-2a21e543").status(Volume.Status.CREATING).availabilityZone("us-east-1a").region("us-east-1").id("vol-2a21e543").size(1).createTime(this.dateService.iso8601DateParse("2009-12-28T05:42:53.000Z")).build();
        this.filterVolumes = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeVolumes"}).addFormParam("Filter.1.Name", new String[]{"snapshot-id"}).addFormParam("Filter.1.Value.1", new String[]{"snap-536d1b3a"}).addFormParam("Signature", new String[]{"7g2ySW39nIVfxtIbuVttUBom7sssmQknxX/9SThkm2Y%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2012-04-16T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
        this.filterSnapshots = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSnapshots"}).addFormParam("Filter.1.Name", new String[]{"volume-id"}).addFormParam("Filter.1.Value.1", new String[]{"4d826724"}).addFormParam("Signature", new String[]{"vT7R4YmfQJPNLSojXEMY1qcErMh0OzrOTYxbGYSZ4Uw%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2012-04-16T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    }

    public void testCreateVolumeInAvailabilityZone() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        builder.putAll(this.describeAvailabilityZonesRequestResponse);
        builder.put((Object)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(EC2ElasticBlockStoreApiExpectTest.payloadFromStringWithContentType((String)"Action=CreateVolume&AvailabilityZone=us-east-1a&Signature=NCu8HU8u0A385rTgj%2BN5lq606jkc1eu88jof9yAxb6s%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Size=4&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-08-31&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build(), (Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/created_volume.xml"))).build());
        ElasticBlockStoreApi client = (ElasticBlockStoreApi)((EC2Api)this.requestsSendResponses((Map)builder.build())).getElasticBlockStoreApi().get();
        Assert.assertEquals((Object)client.createVolumeInAvailabilityZone("us-east-1a", 4), (Object)this.creating);
    }

    public void testCreateVolumeFromSnapshotInAvailabilityZoneEuSetsCorrectEndpoint() {
        String region = "eu-west-1";
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        builder.putAll(this.describeAvailabilityZonesRequestResponse);
        builder.put((Object)this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + region + ".amazonaws.com"})).addFormParam("Action", new String[]{"CreateVolume"}).addFormParam("AvailabilityZone", new String[]{"eu-west-1a"}).addFormParam("Size", new String[]{"1"}).addFormParam("SnapshotId", new String[]{"snap-8b7ffbdd"}).build()), (Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/created_volume.xml"))).build());
        ElasticBlockStoreApi client = (ElasticBlockStoreApi)((EC2Api)this.requestsSendResponses((Map)builder.build())).getElasticBlockStoreApi().get();
        Assert.assertEquals((Object)client.createVolumeFromSnapshotInAvailabilityZone(region + "a", 1, "snap-8b7ffbdd"), (Object)this.creating.toBuilder().region(region).build());
    }

    public void testFilterVolumesWhenResponseIs2xx() {
        HttpResponse filterResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_volumes_single.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filterVolumes, filterResponse);
        Volume volume = (Volume)Iterables.getOnlyElement((Iterable)((ElasticBlockStoreApi)apiWhenExist.getElasticBlockStoreApi().get()).describeVolumesInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"snapshot-id", (Object)"snap-536d1b3a").build()));
        Assert.assertEquals((String)volume.getId(), (String)"vol-4282672b");
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testFilterVolumesWhenResponseIs404() {
        HttpResponse filterResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenNotExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filterVolumes, filterResponse);
        Assert.assertEquals((Set)((ElasticBlockStoreApi)apiWhenNotExist.getElasticBlockStoreApi().get()).describeVolumesInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"snapshot-id", (Object)"snap-536d1b3a").build()), (Set)ImmutableSet.of());
    }

    public void testFilterSnapshotsWhenResponseIs2xx() {
        HttpResponse filterResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_snapshots.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filterSnapshots, filterResponse);
        Snapshot snapshot = (Snapshot)Iterables.getOnlyElement((Iterable)((ElasticBlockStoreApi)apiWhenExist.getElasticBlockStoreApi().get()).describeSnapshotsInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"volume-id", (Object)"4d826724").build(), new DescribeSnapshotsOptions[0]));
        Assert.assertEquals((String)snapshot.getId(), (String)"snap-78a54011");
    }

    public void testFilterSnapshotsWhenResponseIs404() {
        HttpResponse filterResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenNotExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filterSnapshots, filterResponse);
        Assert.assertEquals((Set)((ElasticBlockStoreApi)apiWhenNotExist.getElasticBlockStoreApi().get()).describeSnapshotsInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"volume-id", (Object)"4d826724").build(), new DescribeSnapshotsOptions[0]), (Set)ImmutableSet.of());
    }
}

