/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.features.ElasticIPAddressApi;
import org.jclouds.ec2.internal.BaseEC2ApiExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.internal.BaseRestApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ElasticIPAddressApiExpectTest
extends BaseEC2ApiExpectTest<EC2Api> {
    HttpRequest filter = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(BaseRestApiExpectTest.payloadFromStringWithContentType((String)"Action=DescribeAddresses&Filter.1.Name=instance-id&Filter.1.Value.1=i-f15ebb98&Signature=dJbTUsBGHSrarQQAwmLm8LLI255R/lzdE7ZcYJucOzI%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-08-31&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.put("jclouds.api-version", "2010-08-31");
        return props;
    }

    public void testFilterWhenResponseIs2xx() throws Exception {
        HttpResponse filterResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_addresses_single.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        PublicIpInstanceIdPair address = (PublicIpInstanceIdPair)Iterables.getOnlyElement((Iterable)((ElasticIPAddressApi)apiWhenExist.getElasticIPAddressApi().get()).describeAddressesInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"instance-id", (Object)"i-f15ebb98").build()));
        Assert.assertNotNull((Object)address, (String)"address should not be null");
        Assert.assertEquals((String)address.getPublicIp(), (String)"67.202.55.255");
    }

    public void testFilterWhenResponseIs404() throws Exception {
        HttpResponse filterResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        Assert.assertEquals((Set)((ElasticIPAddressApi)apiWhenDontExist.getElasticIPAddressApi().get()).describeAddressesInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"instance-id", (Object)"i-f15ebb98").build()), (Set)ImmutableSet.of());
    }
}

