/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.TreeSet;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.features.ElasticIPAddressApi;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ElasticIPAddressApiLiveTest")
public class ElasticIPAddressApiLiveTest
extends BaseComputeServiceContextLiveTest {
    private EC2Api ec2Api;
    private ElasticIPAddressApi client;

    public ElasticIPAddressApiLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Api = (EC2Api)((ComputeServiceContext)this.view).unwrapApi(EC2Api.class);
        this.client = (ElasticIPAddressApi)this.ec2Api.getElasticIPAddressApi().get();
    }

    @Test
    void testDescribeAddresses() {
        for (String region : this.ec2Api.getConfiguredRegions()) {
            TreeSet allResults = Sets.newTreeSet((Iterable)this.client.describeAddressesInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.isEmpty()) continue;
            PublicIpInstanceIdPair pair = (PublicIpInstanceIdPair)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)this.client.describeAddressesInRegion(region, new String[]{pair.getPublicIp()}));
            Assert.assertNotNull((Object)result);
            PublicIpInstanceIdPair compare = (PublicIpInstanceIdPair)result.last();
            Assert.assertEquals((Object)compare, (Object)pair);
            TreeSet filterResult = Sets.newTreeSet((Iterable)this.client.describeAddressesInRegionWithFilter(region, (Multimap)ImmutableMultimap.builder().put((Object)"public-ip", (Object)pair.getPublicIp()).build()));
            Assert.assertNotNull((Object)filterResult);
            PublicIpInstanceIdPair filterCompare = (PublicIpInstanceIdPair)filterResult.last();
            Assert.assertEquals((Object)filterCompare, (Object)pair);
        }
    }
}

