/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.ec2.features.BaseEC2ApiTest;
import org.jclouds.ec2.features.ElasticIPAddressApi;
import org.jclouds.ec2.xml.AllocateAddressResponseHandler;
import org.jclouds.ec2.xml.DescribeAddressesResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ElasticIPAddressApiTest")
public class ElasticIPAddressApiTest
extends BaseEC2ApiTest<ElasticIPAddressApi> {
    HttpRequest associateAddress = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"AssociateAddress"}).addFormParam("InstanceId", new String[]{"me"}).addFormParam("PublicIp", new String[]{"127.0.0.1"}).addFormParam("Signature", new String[]{"nLU6xGLqXtT/dmyAvkN4BdL/3CxQlDWJYeskikhl54k%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testDisassociateAddress() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticIPAddressApi.class, (String)"disassociateAddressInRegion", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "127.0.0.1"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DisassociateAddress&PublicIp=127.0.0.1", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAssociateAddress() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticIPAddressApi.class, (String)"associateAddressInRegion", (Class[])new Class[]{String.class, String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "127.0.0.1", "me"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.associateAddress.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testReleaseAddress() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticIPAddressApi.class, (String)"releaseAddressInRegion", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "127.0.0.1"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=ReleaseAddress&PublicIp=127.0.0.1", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeAddresses() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticIPAddressApi.class, (String)"describeAddressesInRegion", (Class[])new Class[]{String.class, String[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "127.0.0.1"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeAddresses&PublicIp.1=127.0.0.1", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeAddressesResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testAllocateAddress() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticIPAddressApi.class, (String)"allocateAddressInRegion", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=AllocateAddress", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, AllocateAddressResponseHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }
}

