/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.internal.BaseEC2ApiExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.internal.BaseRestApiExpectTest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class InstanceApiExpectTest
extends BaseEC2ApiExpectTest<EC2Api> {
    HttpRequest filter = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(BaseRestApiExpectTest.payloadFromStringWithContentType((String)("Action=DescribeInstances&Filter.1.Name=key-name&Filter.1.Value.1=" + Strings2.urlEncode((String)"adriancole.ec21", (char[])new char[0]) + "&Signature=%2B2ktAljlAPNUMAJUFh3poQrTvwcwWytuQFBg/ktKdTc%3D" + "&SignatureMethod=HmacSHA256" + "&SignatureVersion=2" + "&Timestamp=2012-04-16T15%3A54%3A08.897Z" + "&Version=2010-08-31" + "&AWSAccessKeyId=identity"), (String)"application/x-www-form-urlencoded"))).build();

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.put("jclouds.api-version", "2010-08-31");
        return props;
    }

    public void testFilterWhenResponseIs2xx() throws Exception {
        HttpResponse filterResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_instances_running.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        RunningInstance instance = (RunningInstance)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)((InstanceApi)apiWhenExist.getInstanceApi().get()).describeInstancesInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"key-name", (Object)"adriancole.ec21").build()))));
        Assert.assertNotNull((Object)instance, (String)"Instance should not be null");
        Assert.assertEquals((String)instance.getId(), (String)"i-0799056f");
    }

    public void testFilterWhenResponseIs404() throws Exception {
        HttpResponse filterResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        Assert.assertEquals((Set)((InstanceApi)apiWhenDontExist.getInstanceApi().get()).describeInstancesInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"key-name", (Object)"adriancole.ec21").build()), (Set)ImmutableSet.of());
    }
}

