/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Set;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.features.AvailabilityZoneAndRegionApi;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="InstanceApiLiveTest")
public class InstanceApiLiveTest
extends BaseComputeServiceContextLiveTest {
    private EC2Api ec2Api;
    private InstanceApi client;

    public InstanceApiLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Api = (EC2Api)((ComputeServiceContext)this.view).unwrapApi(EC2Api.class);
        this.client = (InstanceApi)this.ec2Api.getInstanceApi().get();
    }

    @Test
    void testDescribeInstances() {
        for (String region : this.ec2Api.getConfiguredRegions()) {
            Set allResults = this.client.describeInstancesInRegion(region, new String[0]);
            Assert.assertNotNull((Object)allResults);
        }
    }

    @Test
    void testFilterInstances() {
        for (String region : ((AvailabilityZoneAndRegionApi)((EC2Api)((ComputeServiceContext)this.view).unwrapApi(EC2Api.class)).getAvailabilityZoneAndRegionApi().get()).describeRegions(new DescribeRegionsOptions[0]).keySet()) {
            Set allResults = this.client.describeInstancesInRegion(region, new String[0]);
            Assert.assertNotNull((Object)allResults);
            if (allResults.isEmpty()) continue;
            RunningInstance instance = (RunningInstance)Iterables.getFirst((Iterable)((Iterable)Iterables.getFirst((Iterable)allResults, null)), null);
            Assert.assertNotNull((Object)instance);
            Set filterResults = this.client.describeInstancesInRegionWithFilter(region, (Multimap)ImmutableMultimap.builder().put((Object)"key-name", (Object)instance.getKeyName()).build());
            Assert.assertNotNull((Object)filterResults);
            Assert.assertTrue((!filterResults.isEmpty() ? 1 : 0) != 0, (String)"No results found for filter, but there should be.");
        }
    }

    @Test(expectedExceptions={AWSResponseException.class})
    void testInvalidFilterInstances() {
        for (String region : ((AvailabilityZoneAndRegionApi)((EC2Api)((ComputeServiceContext)this.view).unwrapApi(EC2Api.class)).getAvailabilityZoneAndRegionApi().get()).describeRegions(new DescribeRegionsOptions[0]).keySet()) {
            Set set = this.client.describeInstancesInRegionWithFilter(region, (Multimap)ImmutableMultimap.builder().put((Object)"invalid-key", (Object)"some-value").build());
        }
    }
}

