/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Set;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.features.KeyPairApi;
import org.jclouds.ec2.internal.BaseEC2ApiExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="KeyPairApiExpectTest")
public class KeyPairApiExpectTest
extends BaseEC2ApiExpectTest<EC2Api> {
    HttpRequest filter = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeKeyPairs"}).addFormParam("Filter.1.Name", new String[]{"key-name"}).addFormParam("Filter.1.Value.1", new String[]{"gsg-keypair"}).addFormParam("Signature", new String[]{"xg8vGx%2Bv9UEG0%2BFGy%2BhincdI2ziWLbwPJvW85l%2Bvqwg%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2012-04-16T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testFilterWhenResponseIs2xx() {
        HttpResponse filterResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_keypairs.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        KeyPair keyPair = (KeyPair)Iterables.getOnlyElement((Iterable)((KeyPairApi)apiWhenExist.getKeyPairApi().get()).describeKeyPairsInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"key-name", (Object)"gsg-keypair").build()));
        Assert.assertEquals((String)keyPair.getKeyName(), (String)"gsg-keypair");
    }

    public void testFilterWhenResponseIs404() {
        HttpResponse filterResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenNotExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        Assert.assertEquals((Set)((KeyPairApi)apiWhenNotExist.getKeyPairApi().get()).describeKeyPairsInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"key-name", (Object)"gsg-keypair").build()), (Set)ImmutableSet.of());
    }
}

