/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.features.KeyPairApi;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="KeyPairApiLiveTest")
public class KeyPairApiLiveTest
extends BaseComputeServiceContextLiveTest {
    private EC2Api ec2Api;
    private KeyPairApi client;
    public static final String PREFIX = System.getProperty("user.name") + "-ec2";

    public KeyPairApiLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Api = (EC2Api)((ComputeServiceContext)this.view).unwrapApi(EC2Api.class);
        this.client = (KeyPairApi)this.ec2Api.getKeyPairApi().get();
    }

    @Test
    void testDescribeKeyPairs() {
        for (String region : this.ec2Api.getConfiguredRegions()) {
            TreeSet allResults = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.isEmpty()) continue;
            KeyPair pair = (KeyPair)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegion(region, new String[]{pair.getKeyName()}));
            Assert.assertNotNull((Object)result);
            KeyPair compare = (KeyPair)result.last();
            Assert.assertEquals((Object)compare, (Object)pair);
        }
    }

    @Test
    void testDescribeKeyPairsWithFilter() {
        for (String region : this.ec2Api.getConfiguredRegions()) {
            TreeSet allResults = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.isEmpty()) continue;
            KeyPair pair = (KeyPair)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegionWithFilter(region, (Multimap)ImmutableMultimap.builder().put((Object)"key-name", (Object)pair.getKeyName()).build()));
            Assert.assertNotNull((Object)result);
            KeyPair compare = (KeyPair)result.last();
            Assert.assertEquals((Object)compare, (Object)pair);
        }
    }

    @Test(expectedExceptions={AWSResponseException.class})
    void testDescribeKeyPairsWithInvalidFilter() {
        for (String region : this.ec2Api.getConfiguredRegions()) {
            TreeSet allResults = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.isEmpty()) continue;
            KeyPair pair = (KeyPair)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)this.client.describeKeyPairsInRegionWithFilter(region, (Multimap)ImmutableMultimap.builder().put((Object)"invalid-filter", (Object)pair.getKeyName()).build()));
        }
    }

    @Test
    void testCreateKeyPair() {
        String keyName = PREFIX + "1";
        try {
            this.client.deleteKeyPairInRegion(null, keyName);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.client.deleteKeyPairInRegion(null, keyName);
        KeyPair result = this.client.createKeyPairInRegion(null, keyName);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getKeyMaterial());
        Assert.assertNotNull((Object)result.getSha1OfPrivateKey());
        Assert.assertEquals((String)result.getKeyName(), (String)keyName);
        LinkedHashSet twoResults = Sets.newLinkedHashSet((Iterable)this.client.describeKeyPairsInRegion(null, new String[]{keyName}));
        Assert.assertNotNull((Object)twoResults);
        Assert.assertEquals((int)twoResults.size(), (int)1);
        KeyPair listPair = (KeyPair)twoResults.iterator().next();
        Assert.assertEquals((String)listPair.getKeyName(), (String)result.getKeyName());
        Assert.assertEquals((String)listPair.getSha1OfPrivateKey(), (String)result.getSha1OfPrivateKey());
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        String keyName = PREFIX + "1";
        try {
            this.client.deleteKeyPairInRegion(null, keyName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDownContext();
    }
}

