/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Set;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.features.SecurityGroupApi;
import org.jclouds.ec2.internal.BaseEC2ApiExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SecurityGroupApiExpectTest")
public class SecurityGroupApiExpectTest
extends BaseEC2ApiExpectTest<EC2Api> {
    HttpRequest filter = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSecurityGroups"}).addFormParam("Filter.1.Name", new String[]{"owner-id"}).addFormParam("Filter.1.Value.1", new String[]{"993194456877"}).addFormParam("Signature", new String[]{"zk8EEWkG9Hi0bBLPueF9WdTUKapxQqUXgyJTxeZHXBc%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2012-04-16T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testFilterWhenResponseIs2xx() {
        HttpResponse filterResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_securitygroups_extension_single.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        SecurityGroup group = (SecurityGroup)Iterables.getOnlyElement((Iterable)((SecurityGroupApi)apiWhenExist.getSecurityGroupApi().get()).describeSecurityGroupsInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"owner-id", (Object)"993194456877").build()));
        Assert.assertEquals((String)group.getId(), (String)"sg-3c6ef654");
    }

    public void testFilterWhenResponseIs404() {
        HttpResponse filterResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenNotExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        Assert.assertEquals((Set)((SecurityGroupApi)apiWhenNotExist.getSecurityGroupApi().get()).describeSecurityGroupsInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"owner-id", (Object)"993194456877").build()), (Set)ImmutableSet.of());
    }
}

