/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Set;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.BundleTask;
import org.jclouds.ec2.features.WindowsApi;
import org.jclouds.ec2.internal.BaseEC2ApiExpectTest;
import org.jclouds.ec2.parse.GetPasswordDataResponseTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="WindowsApiExpectTest")
public class WindowsApiExpectTest
extends BaseEC2ApiExpectTest<EC2Api> {
    HttpRequest get = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(WindowsApiExpectTest.payloadFromStringWithContentType((String)"Action=GetPasswordData&InstanceId=i-2574e22a&Signature=PMr4kU4p%2BSF2ISHXAFUme1kNh%2BCqftIUQchuw3vhKCw%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-08-31&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build();
    HttpRequest filter = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeBundleTasks"}).addFormParam("Filter.1.Name", new String[]{"instance-id"}).addFormParam("Filter.1.Value.1", new String[]{"i-12345678"}).addFormParam("Signature", new String[]{"y0y3UBUKU/uYwbWPTCbkXzprU%2B8fMhg5LfF%2B5hWU2F4%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2012-04-16T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-08-31"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testGetPasswordDataWhenResponseIs2xx() throws Exception {
        HttpResponse getResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/get_passworddata.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestSendsResponse(this.get, getResponse);
        Assert.assertEquals((String)((WindowsApi)apiWhenExist.getWindowsApi().get()).getPasswordDataForInstance("i-2574e22a").toString(), (String)new GetPasswordDataResponseTest().expected().toString());
    }

    public void testGetPasswordDataWhenResponseIs404() throws Exception {
        HttpResponse getResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestSendsResponse(this.get, getResponse);
        Assert.assertNull((Object)((WindowsApi)apiWhenDontExist.getWindowsApi().get()).getPasswordDataForInstance("i-2574e22a"));
    }

    public void testFilterBundleTasksWhenResponseIs2xx() {
        HttpResponse filterResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_bundle_tasks.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        BundleTask task = (BundleTask)Iterables.getOnlyElement((Iterable)((WindowsApi)apiWhenExist.getWindowsApi().get()).describeBundleTasksInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"instance-id", (Object)"i-12345678").build()));
        Assert.assertEquals((String)task.getBundleId(), (String)"bun-c1a540a8");
    }

    public void testFilterBundleTasksWhenResponseIs404() {
        HttpResponse filterResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenNotExist = (EC2Api)this.requestsSendResponses(this.describeRegionsRequest, this.describeRegionsResponse, this.filter, filterResponse);
        Assert.assertEquals((Set)((WindowsApi)apiWhenNotExist.getWindowsApi().get()).describeBundleTasksInRegionWithFilter("us-east-1", (Multimap)ImmutableMultimap.builder().put((Object)"instance-id", (Object)"i-12345678").build()), (Set)ImmutableSet.of());
    }
}

