/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.options.RegisterImageOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RegisterImageOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(RegisterImageOptions.class));
        assert (!String.class.isAssignableFrom(RegisterImageOptions.class));
    }

    @Test
    public void testWithDescription() {
        RegisterImageOptions options = new RegisterImageOptions();
        options.withDescription("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithDescription() {
        RegisterImageOptions options = new RegisterImageOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithDescriptionStatic() {
        RegisterImageOptions options = RegisterImageOptions.Builder.withDescription((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithDescriptionNPE() {
        RegisterImageOptions.Builder.withDescription(null);
    }

    @Test
    public void testWithArchitecture() {
        RegisterImageOptions options = new RegisterImageOptions();
        options.asArchitecture(Image.Architecture.I386);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Architecture"), (Collection)ImmutableList.of((Object)"i386"));
    }

    @Test
    public void testNullWithArchitecture() {
        RegisterImageOptions options = new RegisterImageOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Architecture"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithArchitectureStatic() {
        RegisterImageOptions options = RegisterImageOptions.Builder.asArchitecture((Image.Architecture)Image.Architecture.I386);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Architecture"), (Collection)ImmutableList.of((Object)"i386"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithArchitectureNPE() {
        RegisterImageOptions.Builder.asArchitecture(null);
    }

    @Test
    public void testWithKernelId() {
        RegisterImageOptions options = new RegisterImageOptions();
        options.withKernelId("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithKernelId() {
        RegisterImageOptions options = new RegisterImageOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithKernelIdStatic() {
        RegisterImageOptions options = RegisterImageOptions.Builder.withKernelId((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithKernelIdNPE() {
        RegisterImageOptions.Builder.withKernelId(null);
    }

    @Test
    public void testWithRamdisk() {
        RegisterImageOptions options = new RegisterImageOptions();
        options.withRamdisk("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithRamdisk() {
        RegisterImageOptions options = new RegisterImageOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithRamdiskStatic() {
        RegisterImageOptions options = RegisterImageOptions.Builder.withRamdisk((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithRamdiskNPE() {
        RegisterImageOptions.Builder.withRamdisk(null);
    }
}

