/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.parse;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import org.jclouds.ec2.domain.Subnet;
import org.jclouds.ec2.xml.DescribeSubnetsResponseHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeSubnetsResponseTest")
public class DescribeSubnetsResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_subnets.xml");
        FluentIterable<Subnet> expected = this.expected();
        DescribeSubnetsResponseHandler handler = (DescribeSubnetsResponseHandler)this.injector.getInstance(DescribeSubnetsResponseHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public FluentIterable<Subnet> expected() {
        return FluentIterable.from((Iterable)ImmutableSet.builder().add((Object)Subnet.builder().subnetId("subnet-9d4a7b6c").subnetState(Subnet.State.AVAILABLE).vpcId("vpc-1a2b3c4d").cidrBlock("10.0.1.0/24").availableIpAddressCount(250).availabilityZone("us-east-1a").tag("Name", "ec2-o").tag("Empty", "").build()).add((Object)Subnet.builder().subnetId("subnet-6e7f829e").subnetState(Subnet.State.AVAILABLE).vpcId("vpc-1a2b3c4d").cidrBlock("10.0.0.0/24").availableIpAddressCount(250).availabilityZone("us-east-1a").build()).build());
    }
}

