/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.parse;

import java.io.InputStream;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.ec2.domain.PasswordData;
import org.jclouds.ec2.xml.GetPasswordDataResponseHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GetPasswordDataResponseTest")
public class GetPasswordDataResponseTest
extends BaseHandlerTest {
    protected final DateService dateService = new SimpleDateFormatDateService();

    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/get_passworddata.xml");
        PasswordData expected = this.expected();
        GetPasswordDataResponseHandler handler = (GetPasswordDataResponseHandler)this.injector.getInstance(GetPasswordDataResponseHandler.class);
        PasswordData result = (PasswordData)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public PasswordData expected() {
        return PasswordData.builder().instanceId("i-2574e22a").timestamp(this.dateService.iso8601DateParse("2012-07-30T07:27:23.000+0000")).passwordData("TGludXggdmVyc2lvbiAyLjYuMTYteGVuVSAoYnVpbGRlckBwYXRjaGJhdC5hbWF6b25zYSkgKGdj").build();
    }
}

