/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.predicates;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import org.easymock.EasyMock;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.features.ElasticBlockStoreApi;
import org.jclouds.ec2.predicates.VolumeDetached;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true)
public class VolumeDetachedTest {
    private ElasticBlockStoreApi client;
    private VolumeDetached volumeDetached;

    @BeforeMethod
    public void setUp() {
        this.client = (ElasticBlockStoreApi)EasyMock.createMock(ElasticBlockStoreApi.class);
        this.volumeDetached = new VolumeDetached(this.client);
    }

    @Test
    public void testVolumeWithEmptyListOfAttachments() {
        Attachment attachment = this.newAttachmentWithStatus(Attachment.Status.ATTACHED);
        HashSet volumes = Sets.newHashSet((Object[])new Volume[]{this.newVolumeWithAttachments(new Attachment[0])});
        EasyMock.expect((Object)this.client.describeVolumesInRegion(attachment.getRegion(), new String[]{attachment.getVolumeId()})).andReturn((Object)volumes);
        EasyMock.replay((Object[])new Object[]{this.client});
        Assert.assertTrue((boolean)this.volumeDetached.apply(attachment));
        EasyMock.verify((Object[])new Object[]{this.client});
    }

    @DataProvider(name="notDetachedStatuses")
    public Object[][] provideNotDetachedStatuses() {
        return new Object[][]{{Attachment.Status.ATTACHED}, {Attachment.Status.ATTACHING}, {Attachment.Status.BUSY}, {Attachment.Status.DETACHING}, {Attachment.Status.UNRECOGNIZED}};
    }

    @Test(dataProvider="notDetachedStatuses")
    public void testWithDifferentStatus(Attachment.Status attachmentStatus) {
        Attachment attachment = this.newAttachmentWithStatus(attachmentStatus);
        HashSet volumes = Sets.newHashSet((Object[])new Volume[]{this.newVolumeWithAttachments(attachment)});
        EasyMock.expect((Object)this.client.describeVolumesInRegion(attachment.getRegion(), new String[]{attachment.getVolumeId()})).andReturn((Object)volumes);
        EasyMock.replay((Object[])new Object[]{this.client});
        Assert.assertFalse((boolean)this.volumeDetached.apply(attachment));
        EasyMock.verify((Object[])new Object[]{this.client});
    }

    @Test
    public void testWithStatusDetached() {
        Attachment attachment = this.newAttachmentWithStatus(Attachment.Status.DETACHED);
        HashSet volumes = Sets.newHashSet((Object[])new Volume[]{this.newVolumeWithAttachments(attachment)});
        EasyMock.expect((Object)this.client.describeVolumesInRegion(attachment.getRegion(), new String[]{attachment.getVolumeId()})).andReturn((Object)volumes);
        EasyMock.replay((Object[])new Object[]{this.client});
        Assert.assertTrue((boolean)this.volumeDetached.apply(attachment));
        EasyMock.verify((Object[])new Object[]{this.client});
    }

    private Volume newVolumeWithAttachments(Attachment ... attachments) {
        return Volume.builder().region("us-east-1").attachments(attachments).build();
    }

    private Attachment newAttachmentWithStatus(Attachment.Status status) {
        return Attachment.builder().volumeId("1").status(status).region("us-east-1").attachTime(new Date()).device("/dev/sda").instanceId("us-east-1/i-1234").build();
    }
}

